/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uri.factory;

import java.util.Objects;
import org.eclipse.uprotocol.UServiceTopic;
import org.eclipse.uprotocol.v1.UResource;

public interface UResourceBuilder {
    public static final int MIN_TOPIC_ID = 32768;

    public static UResource forRpcResponse() {
        return UResource.newBuilder().setName("rpc").setInstance("response").setId(0).build();
    }

    public static UResource forRpcRequest(String method) {
        return UResourceBuilder.forRpcRequest(method, null);
    }

    public static UResource forRpcRequest(String method, Integer id) {
        UResource.Builder builder = UResource.newBuilder().setName("rpc");
        if (method != null) {
            builder.setInstance(method);
        }
        if (id != null) {
            builder.setId(id);
        }
        return builder.build();
    }

    public static UResource forRpcRequest(Integer id) {
        return UResourceBuilder.forRpcRequest(null, id);
    }

    public static UResource fromId(Integer id) {
        Objects.requireNonNull(id, "id cannot be null");
        if (id < 0) {
            return UResource.getDefaultInstance();
        }
        return id == 0 ? UResourceBuilder.forRpcResponse() : (id < 32768 ? UResourceBuilder.forRpcRequest(id) : UResource.newBuilder().setId(id).build());
    }

    public static UResource fromUServiceTopic(UServiceTopic topic) {
        Objects.requireNonNull(topic, "topic cannot be null");
        String[] nameAndInstanceParts = topic.getName().split("\\.");
        String resourceName = nameAndInstanceParts[0];
        String resourceInstance = nameAndInstanceParts.length > 1 ? nameAndInstanceParts[1] : null;
        UResource.Builder builder = UResource.newBuilder().setName(resourceName).setId(topic.getId()).setMessage(topic.getMessage());
        if (resourceInstance != null) {
            builder.setInstance(resourceInstance);
        }
        return builder.build();
    }
}

