/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uri.serializer;

public interface IpAddress {
    public static byte[] toBytes(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            return new byte[0];
        }
        if (IpAddress.isValidIPv4Address(ipAddress)) {
            return IpAddress.convertIPv4ToByteArray(ipAddress);
        }
        if (IpAddress.isValidIPv6Address(ipAddress)) {
            return IpAddress.convertIPv6ToByteArray(ipAddress);
        }
        return new byte[0];
    }

    public static boolean isValid(String ipAddress) {
        return ipAddress != null && !ipAddress.isEmpty() && (IpAddress.isValidIPv4Address(ipAddress) || IpAddress.isValidIPv6Address(ipAddress));
    }

    private static boolean isValidIPv4Address(String ipAddress) {
        String[] octets = ipAddress.split("\\.");
        if (octets.length != 4) {
            return false;
        }
        for (String octet : octets) {
            try {
                int value = Integer.parseInt(octet);
                if (value >= 0 && value <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static byte[] convertIPv4ToByteArray(String ipAddress) {
        String[] octets = ipAddress.split("\\.");
        byte[] ipAddressBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ipAddressBytes[i] = (byte)Integer.parseInt(octets[i]);
        }
        return ipAddressBytes;
    }

    private static boolean isValidIPv6Address(String ipAddress) {
        String[] groups = ipAddress.split(":");
        if (groups.length > 8) {
            return false;
        }
        boolean hasDoubleColon = false;
        int emptyGroups = 0;
        for (int i = 0; i < groups.length; ++i) {
            String group = groups[i];
            if (group.isEmpty()) {
                if (++emptyGroups > 1) {
                    return false;
                }
                hasDoubleColon = true;
                continue;
            }
            for (int j = 0; j < group.length(); ++j) {
                char c = group.charAt(j);
                if (IpAddress.isValidHexDigit(c)) continue;
                return false;
            }
        }
        if (ipAddress.endsWith(":")) {
            if (emptyGroups > 0) {
                return false;
            }
            hasDoubleColon = true;
        }
        return hasDoubleColon || groups.length == 8;
    }

    private static boolean isValidHexDigit(char c) {
        return c >= 'a' && c <= 'f' || c >= '0' && c <= '9' || c >= 'A' && c <= 'F';
    }

    private static byte[] convertIPv6ToByteArray(String ipAddress) {
        String[] groups = ipAddress.split(":");
        byte[] ipAddressBytes = new byte[16];
        int index = 0;
        for (int i = 0; i < groups.length; ++i) {
            String group = groups[i];
            if (group.isEmpty()) {
                int emptyGroups = 8 - (groups.length - 1);
                for (int j = 0; j < emptyGroups; ++j) {
                    ipAddressBytes[index++] = 0;
                    ipAddressBytes[index++] = 0;
                }
                continue;
            }
            int value = Integer.parseInt(group, 16);
            ipAddressBytes[index++] = (byte)(value >> 8 & 0xFF);
            ipAddressBytes[index++] = (byte)(value & 0xFF);
        }
        return ipAddressBytes;
    }
}

