/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uri.serializer;

import java.util.Objects;
import org.eclipse.uprotocol.uri.serializer.UriSerializer;
import org.eclipse.uprotocol.uri.validator.UriValidator;
import org.eclipse.uprotocol.v1.UAuthority;
import org.eclipse.uprotocol.v1.UEntity;
import org.eclipse.uprotocol.v1.UResource;
import org.eclipse.uprotocol.v1.UUri;

public class LongUriSerializer
implements UriSerializer<String> {
    private static final LongUriSerializer INSTANCE = new LongUriSerializer();

    private LongUriSerializer() {
    }

    public static LongUriSerializer instance() {
        return INSTANCE;
    }

    @Override
    public String serialize(UUri Uri) {
        if (Uri == null || UriValidator.isEmpty(Uri)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (Uri.hasAuthority()) {
            sb.append("//");
            sb.append(Uri.getAuthority().getName());
        }
        sb.append("/");
        sb.append(LongUriSerializer.buildSoftwareEntityPartOfUri(Uri.getEntity()));
        sb.append(LongUriSerializer.buildResourcePartOfUri(Uri));
        return sb.toString().replaceAll("/+$", "");
    }

    private static String buildResourcePartOfUri(UUri uri) {
        if (!uri.hasResource()) {
            return "";
        }
        UResource uResource = uri.getResource();
        StringBuilder sb = new StringBuilder("/");
        sb.append(uResource.getName());
        if (uResource.hasInstance()) {
            sb.append(".").append(uResource.getInstance());
        }
        if (uResource.hasMessage()) {
            sb.append("#").append(uResource.getMessage());
        }
        return sb.toString();
    }

    private static String buildSoftwareEntityPartOfUri(UEntity use) {
        StringBuilder sb = new StringBuilder(use.getName().trim());
        sb.append("/");
        if (use.getVersionMajor() > 0) {
            sb.append(use.getVersionMajor());
        }
        return sb.toString();
    }

    @Override
    public UUri deserialize(String uProtocolUri) {
        String useName;
        if (uProtocolUri == null || uProtocolUri.isBlank()) {
            return UUri.getDefaultInstance();
        }
        String uri = uProtocolUri.contains(":") ? uProtocolUri.substring(uProtocolUri.indexOf(":") + 1) : uProtocolUri.replace('\\', '/');
        boolean isLocal = !uri.startsWith("//");
        String[] uriParts = uri.split("/");
        int numberOfPartsInUri = uriParts.length;
        if (numberOfPartsInUri == 0 || numberOfPartsInUri == 1) {
            return UUri.getDefaultInstance();
        }
        String useVersion = "";
        UResource uResource = null;
        UAuthority uAuthority = null;
        if (isLocal) {
            useName = uriParts[1];
            if (numberOfPartsInUri > 2) {
                useVersion = uriParts[2];
                if (numberOfPartsInUri > 3) {
                    uResource = LongUriSerializer.parseFromString(uriParts[3]);
                }
            }
        } else {
            if (uriParts[2].isBlank()) {
                return UUri.getDefaultInstance();
            }
            uAuthority = UAuthority.newBuilder().setName(uriParts[2]).build();
            if (uriParts.length > 3) {
                useName = uriParts[3];
                if (numberOfPartsInUri > 4) {
                    useVersion = uriParts[4];
                    if (numberOfPartsInUri > 5) {
                        uResource = LongUriSerializer.parseFromString(uriParts[5]);
                    }
                }
            } else {
                return UUri.newBuilder().setAuthority(uAuthority).build();
            }
        }
        Integer useVersionInt = null;
        try {
            if (!useVersion.isBlank()) {
                useVersionInt = Integer.valueOf(useVersion);
            }
        }
        catch (NumberFormatException ignored) {
            return UUri.getDefaultInstance();
        }
        UEntity.Builder UEntityFactory2 = UEntity.newBuilder().setName(useName);
        if (useVersionInt != null) {
            UEntityFactory2.setVersionMajor(useVersionInt);
        }
        UUri.Builder uriBuilder = UUri.newBuilder().setEntity(UEntityFactory2);
        if (uAuthority != null) {
            uriBuilder.setAuthority(uAuthority);
        }
        if (uResource != null) {
            uriBuilder.setResource(uResource);
        }
        return uriBuilder.build();
    }

    private static UResource parseFromString(String resourceString) {
        Objects.requireNonNull(resourceString, " Resource must have a command name.");
        String[] parts = resourceString.split("#");
        String nameAndInstance = parts[0];
        String[] nameAndInstanceParts = nameAndInstance.split("\\.");
        String resourceName = nameAndInstanceParts[0];
        String resourceInstance = nameAndInstanceParts.length > 1 ? nameAndInstanceParts[1] : null;
        String resourceMessage = parts.length > 1 ? parts[1] : null;
        UResource.Builder uResourceBuilder = UResource.newBuilder().setName(resourceName);
        if (resourceInstance != null) {
            uResourceBuilder.setInstance(resourceInstance);
        }
        if (resourceMessage != null) {
            uResourceBuilder.setMessage(resourceMessage);
        }
        if (resourceName.contains("rpc") && resourceInstance != null && resourceInstance.contains("response")) {
            uResourceBuilder.setId(0);
        }
        return uResourceBuilder.build();
    }
}

