/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uri.serializer;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.uprotocol.uri.factory.UResourceBuilder;
import org.eclipse.uprotocol.uri.serializer.UriSerializer;
import org.eclipse.uprotocol.uri.validator.UriValidator;
import org.eclipse.uprotocol.v1.UAuthority;
import org.eclipse.uprotocol.v1.UEntity;
import org.eclipse.uprotocol.v1.UUri;

public class MicroUriSerializer
implements UriSerializer<byte[]> {
    static final int LOCAL_MICRO_URI_LENGTH = 8;
    static final int IPV4_MICRO_URI_LENGTH = 12;
    static final int IPV6_MICRO_URI_LENGTH = 24;
    static final byte UP_VERSION = 1;
    private static final MicroUriSerializer INSTANCE = new MicroUriSerializer();

    private MicroUriSerializer() {
    }

    public static MicroUriSerializer instance() {
        return INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] serialize(UUri Uri) {
        AddressType type = AddressType.LOCAL;
        if (Uri == null || UriValidator.isEmpty(Uri) || !UriValidator.isMicroForm(Uri)) {
            return new byte[0];
        }
        Optional<Integer> maybeUeId = Optional.ofNullable(Uri.getEntity().getId());
        Optional<Integer> maybeUResourceId = Optional.ofNullable(Uri.getResource().getId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(1);
        if (Uri.getAuthority().hasIp()) {
            Integer length = Uri.getAuthority().getIp().size();
            if (length == 4) {
                type = AddressType.IPv4;
            } else {
                if (length != 16) return new byte[0];
                type = AddressType.IPv6;
            }
        } else {
            type = Uri.getAuthority().hasId() ? AddressType.ID : AddressType.LOCAL;
        }
        os.write(type.getValue());
        os.write(maybeUResourceId.get() >> 8);
        os.write(maybeUResourceId.get());
        os.write(maybeUeId.get() >> 8);
        os.write(maybeUeId.get());
        os.write(Uri.getEntity().getVersionMajor() == 0 ? 0 : Uri.getEntity().getVersionMajor());
        os.write(0);
        if (type == AddressType.LOCAL) return os.toByteArray();
        if (type == AddressType.ID) {
            os.write(Uri.getAuthority().getId().size());
        }
        try {
            if (Uri.getAuthority().hasIp()) {
                os.write(Uri.getAuthority().getIp().toByteArray());
                return os.toByteArray();
            } else {
                os.write(Uri.getAuthority().getId().toByteArray());
            }
            return os.toByteArray();
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    @Override
    public UUri deserialize(byte[] microUri) {
        if (microUri == null || microUri.length < 8) {
            return UUri.getDefaultInstance();
        }
        if (microUri[0] != 1) {
            return UUri.getDefaultInstance();
        }
        int uResourceId = (microUri[2] & 0xFF) << 8 | microUri[3] & 0xFF;
        Optional<AddressType> type = AddressType.from(microUri[1]);
        if (type.isEmpty()) {
            return UUri.getDefaultInstance();
        }
        AddressType addressType = type.get();
        if (addressType == AddressType.LOCAL && microUri.length != 8) {
            return UUri.getDefaultInstance();
        }
        if (addressType == AddressType.IPv4 && microUri.length != 12) {
            return UUri.getDefaultInstance();
        }
        if (addressType == AddressType.IPv6 && microUri.length != 24) {
            return UUri.getDefaultInstance();
        }
        int ueId = (microUri[4] & 0xFF) << 8 | microUri[5] & 0xFF;
        int uiVersion = Byte.toUnsignedInt(microUri[6]);
        UAuthority uAuthority = null;
        switch (addressType) {
            case IPv4: 
            case IPv6: {
                uAuthority = UAuthority.newBuilder().setIp(ByteString.copyFrom((byte[])microUri, (int)8, (int)(addressType == AddressType.IPv4 ? 4 : 16))).build();
                break;
            }
            case ID: {
                int length = Byte.toUnsignedInt(microUri[8]);
                uAuthority = UAuthority.newBuilder().setId(ByteString.copyFrom((byte[])microUri, (int)9, (int)length)).build();
                break;
            }
        }
        UUri.Builder uriBuilder = UUri.newBuilder().setEntity(UEntity.newBuilder().setId(ueId).setVersionMajor(uiVersion)).setResource(UResourceBuilder.fromId(uResourceId));
        if (uAuthority != null) {
            uriBuilder.setAuthority(uAuthority);
        }
        return uriBuilder.build();
    }

    private static enum AddressType {
        LOCAL(0),
        IPv4(1),
        IPv6(2),
        ID(3);

        private final int value;

        private AddressType(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }

        public static Optional<AddressType> from(int value) {
            return Arrays.stream(AddressType.values()).filter(p -> p.getValue() == value).findAny();
        }
    }
}

