/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uri.serializer;

import com.google.protobuf.ByteString;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.eclipse.uprotocol.uri.factory.UResourceBuilder;
import org.eclipse.uprotocol.uri.serializer.IpAddress;
import org.eclipse.uprotocol.uri.serializer.UriSerializer;
import org.eclipse.uprotocol.uri.validator.UriValidator;
import org.eclipse.uprotocol.v1.UAuthority;
import org.eclipse.uprotocol.v1.UEntity;
import org.eclipse.uprotocol.v1.UResource;
import org.eclipse.uprotocol.v1.UUri;

public class ShortUriSerializer
implements UriSerializer<String> {
    private static final ShortUriSerializer INSTANCE = new ShortUriSerializer();

    private ShortUriSerializer() {
    }

    public static ShortUriSerializer instance() {
        return INSTANCE;
    }

    @Override
    public String serialize(UUri Uri) {
        if (Uri == null || UriValidator.isEmpty(Uri)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (Uri.hasAuthority()) {
            UAuthority authority = Uri.getAuthority();
            if (authority.hasIp()) {
                try {
                    sb.append("/");
                    sb.append(InetAddress.getByAddress(authority.getIp().toByteArray()));
                }
                catch (UnknownHostException e) {
                    return "";
                }
            } else if (authority.hasId()) {
                sb.append("//");
                sb.append(authority.getId().toStringUtf8());
            } else {
                return "";
            }
        }
        sb.append("/");
        sb.append(ShortUriSerializer.buildSoftwareEntityPartOfUri(Uri.getEntity()));
        sb.append(ShortUriSerializer.buildResourcePartOfUri(Uri));
        return sb.toString().replaceAll("/+$", "");
    }

    private static String buildResourcePartOfUri(UUri uri) {
        if (!uri.hasResource()) {
            return "";
        }
        UResource uResource = uri.getResource();
        StringBuilder sb = new StringBuilder("/");
        sb.append(uResource.getId());
        return sb.toString();
    }

    private static String buildSoftwareEntityPartOfUri(UEntity use) {
        StringBuilder sb = new StringBuilder();
        sb.append(use.getId());
        sb.append("/");
        if (use.getVersionMajor() > 0) {
            sb.append(use.getVersionMajor());
        }
        return sb.toString();
    }

    @Override
    public UUri deserialize(String uProtocolUri) {
        if (uProtocolUri == null || uProtocolUri.isBlank()) {
            return UUri.getDefaultInstance();
        }
        String uri = uProtocolUri.contains(":") ? uProtocolUri.substring(uProtocolUri.indexOf(":") + 1) : uProtocolUri.replace('\\', '/');
        boolean isLocal = !uri.startsWith("//");
        String[] uriParts = uri.split("/");
        int numberOfPartsInUri = uriParts.length;
        if (numberOfPartsInUri < 2) {
            return UUri.getDefaultInstance();
        }
        String uEId = "";
        String ueVersion = "";
        UResource uResource = null;
        UAuthority uAuthority = null;
        if (isLocal) {
            uEId = uriParts[1];
            if (numberOfPartsInUri > 2) {
                ueVersion = uriParts[2];
                if (numberOfPartsInUri > 3) {
                    uResource = ShortUriSerializer.parseFromString(uriParts[3]);
                }
                if (numberOfPartsInUri > 4) {
                    return UUri.getDefaultInstance();
                }
            }
        } else {
            if (uriParts[2].isBlank()) {
                return UUri.getDefaultInstance();
            }
            uAuthority = IpAddress.isValid(uriParts[2]) ? UAuthority.newBuilder().setIp(ByteString.copyFrom((byte[])IpAddress.toBytes(uriParts[2]))).build() : UAuthority.newBuilder().setId(ByteString.copyFromUtf8((String)uriParts[2])).build();
            if (uriParts.length > 3) {
                uEId = uriParts[3];
                if (numberOfPartsInUri > 4) {
                    ueVersion = uriParts[4];
                    if (numberOfPartsInUri > 5) {
                        uResource = ShortUriSerializer.parseFromString(uriParts[5]);
                    }
                    if (numberOfPartsInUri > 6) {
                        return UUri.getDefaultInstance();
                    }
                }
            } else {
                return UUri.newBuilder().setAuthority(uAuthority).build();
            }
        }
        Integer useVersionInt = null;
        Integer ueIdInt = null;
        try {
            if (!ueVersion.isBlank()) {
                useVersionInt = Integer.valueOf(ueVersion);
            }
            if (!uEId.isBlank()) {
                ueIdInt = Integer.parseInt(uEId);
            }
        }
        catch (NumberFormatException ignored) {
            return UUri.getDefaultInstance();
        }
        UEntity.Builder uEntityBuilder = UEntity.newBuilder();
        if (ueIdInt != null) {
            uEntityBuilder.setId(ueIdInt);
        }
        if (useVersionInt != null) {
            uEntityBuilder.setVersionMajor(useVersionInt);
        }
        UUri.Builder uriBuilder = UUri.newBuilder().setEntity(uEntityBuilder);
        if (uAuthority != null) {
            uriBuilder.setAuthority(uAuthority);
        }
        if (uResource != null) {
            uriBuilder.setResource(uResource);
        }
        return uriBuilder.build();
    }

    private static UResource parseFromString(String resourceString) {
        Objects.requireNonNull(resourceString, " Resource must have a command name.");
        Integer id = null;
        try {
            id = Integer.parseInt(resourceString);
        }
        catch (NumberFormatException ignored) {
            return UResource.getDefaultInstance();
        }
        return UResourceBuilder.fromId(id);
    }
}

