/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uri.validator;

import org.eclipse.uprotocol.uri.factory.UResourceBuilder;
import org.eclipse.uprotocol.v1.UAuthority;
import org.eclipse.uprotocol.v1.UResource;
import org.eclipse.uprotocol.v1.UUri;
import org.eclipse.uprotocol.validation.ValidationResult;

public interface UriValidator {
    public static ValidationResult validate(UUri uri) {
        if (UriValidator.isEmpty(uri)) {
            return ValidationResult.failure("Uri is empty.");
        }
        if (uri.hasAuthority() && !UriValidator.isRemote(uri.getAuthority())) {
            return ValidationResult.failure("Uri is remote missing uAuthority.");
        }
        if (uri.getEntity().getName().isBlank()) {
            return ValidationResult.failure("Uri is missing uSoftware Entity name.");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validateRpcMethod(UUri uri) {
        ValidationResult status = UriValidator.validate(uri);
        if (status.isFailure()) {
            return status;
        }
        if (!UriValidator.isRpcMethod(uri)) {
            return ValidationResult.failure("Invalid RPC method uri. Uri should be the method to be called, or method from response.");
        }
        return ValidationResult.success();
    }

    public static ValidationResult validateRpcResponse(UUri uri) {
        ValidationResult status = UriValidator.validate(uri);
        if (status.isFailure()) {
            return status;
        }
        if (!UriValidator.isRpcResponse(uri)) {
            return ValidationResult.failure("Invalid RPC response type.");
        }
        return ValidationResult.success();
    }

    public static boolean isEmpty(UUri uri) {
        return uri == null || uri.equals(UUri.getDefaultInstance());
    }

    public static boolean isRpcMethod(UUri uri) {
        return uri != null && UriValidator.isRpcMethod(uri.getResource());
    }

    public static boolean isRpcMethod(UResource resource) {
        return resource != null && resource.getName().equals("rpc") && (resource.hasInstance() && !resource.getInstance().trim().isEmpty() || resource.hasId() && resource.getId() < 32768);
    }

    public static boolean isResolved(UUri uri) {
        return UriValidator.isLongForm(uri) && UriValidator.isMicroForm(uri);
    }

    public static boolean isRpcResponse(UUri uri) {
        return uri != null && uri.getResource().equals(UResourceBuilder.forRpcResponse());
    }

    public static boolean isMicroForm(UUri uri) {
        return uri != null && !UriValidator.isEmpty(uri) && uri.getEntity().hasId() && uri.getResource().hasId() && UriValidator.isMicroForm(uri.getAuthority());
    }

    public static boolean isMicroForm(UAuthority authority) {
        return UriValidator.isLocal(authority) || authority.hasIp() || authority.hasId();
    }

    public static boolean isLongForm(UUri uri) {
        return uri != null && !UriValidator.isEmpty(uri) && UriValidator.isLongForm(uri.getAuthority()) && !uri.getEntity().getName().isBlank() && !uri.getResource().getName().isBlank();
    }

    public static boolean isLongForm(UAuthority authority) {
        return authority != null && (UriValidator.isLocal(authority) || authority.hasName() && !authority.getName().isBlank());
    }

    public static boolean isLocal(UAuthority authority) {
        return authority != null && authority.equals(UAuthority.getDefaultInstance());
    }

    public static boolean isRemote(UAuthority authority) {
        return authority != null && !authority.equals(UAuthority.getDefaultInstance());
    }

    public static boolean isShortForm(UUri uri) {
        return UriValidator.isMicroForm(uri);
    }
}

