/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uuid.factory;

import com.github.f4b6a3.uuid.UuidCreator;
import java.time.Instant;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;

public abstract class UuidFactory {
    public org.eclipse.uprotocol.v1.UUID create() {
        return this.create(Instant.now());
    }

    public abstract org.eclipse.uprotocol.v1.UUID create(Instant var1);

    private static class Uuidv8Factory
    extends UuidFactory {
        public static final int UUIDV8_VERSION = 8;
        private static final int MAX_COUNT = 4095;
        private static final long lsb = new Random().nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        private static long msb = 32768L;

        private Uuidv8Factory() {
        }

        @Override
        public synchronized org.eclipse.uprotocol.v1.UUID create(Instant instant) {
            long time = Objects.requireNonNullElse(instant, Instant.now()).toEpochMilli();
            if (time == msb >> 16) {
                if ((msb & 0xFFFL) < 4095L) {
                    ++msb;
                }
            } else {
                msb = time << 16 | 0x8000L;
            }
            return org.eclipse.uprotocol.v1.UUID.newBuilder().setMsb(msb).setLsb(lsb).build();
        }
    }

    private static class Uuidv6Factory
    extends UuidFactory {
        private Uuidv6Factory() {
        }

        @Override
        public org.eclipse.uprotocol.v1.UUID create(Instant instant) {
            UUID uuid_java = UuidCreator.getTimeOrdered((Instant)Objects.requireNonNullElse(instant, Instant.now()), null, null);
            return org.eclipse.uprotocol.v1.UUID.newBuilder().setMsb(uuid_java.getMostSignificantBits()).setLsb(uuid_java.getLeastSignificantBits()).build();
        }
    }

    public static enum Factories {
        UUIDV6(new Uuidv6Factory()),
        UPROTOCOL(new Uuidv8Factory());

        private final UuidFactory factory;

        private Factories(UuidFactory factory) {
            this.factory = factory;
        }

        public UuidFactory factory() {
            return this.factory;
        }
    }
}

