/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVariant;
import com.github.f4b6a3.uuid.util.UuidTime;
import com.github.f4b6a3.uuid.util.UuidUtil;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.uprotocol.v1.UAttributes;

public interface UuidUtils {
    public static Optional<Version> getVersion(org.eclipse.uprotocol.v1.UUID uuid) {
        return uuid == null ? Optional.empty() : Version.getVersion((int)(uuid.getMsb() >> 12 & 0xFL));
    }

    public static Optional<Integer> getVariant(org.eclipse.uprotocol.v1.UUID uuid) {
        return uuid == null ? Optional.empty() : Optional.of((int)(uuid.getLsb() >>> (int)(64L - (uuid.getLsb() >>> 62)) & uuid.getLsb() >> 63));
    }

    public static boolean isUProtocol(org.eclipse.uprotocol.v1.UUID uuid) {
        Optional<Version> version = UuidUtils.getVersion(uuid);
        return uuid != null && version.isPresent() && version.get() == Version.VERSION_UPROTOCOL;
    }

    public static boolean isUuidv6(org.eclipse.uprotocol.v1.UUID uuid) {
        Optional<Version> version = UuidUtils.getVersion(uuid);
        Optional<Integer> variant = UuidUtils.getVariant(uuid);
        return uuid != null && version.isPresent() && version.get() == Version.VERSION_TIME_ORDERED && variant.get().intValue() == UuidVariant.VARIANT_RFC_4122.getValue();
    }

    public static boolean isUuid(org.eclipse.uprotocol.v1.UUID uuid) {
        return UuidUtils.isUProtocol(uuid) || UuidUtils.isUuidv6(uuid);
    }

    public static Optional<Long> getTime(org.eclipse.uprotocol.v1.UUID uuid) {
        Long time = null;
        Optional<Version> version = UuidUtils.getVersion(uuid);
        if (uuid == null || version.isEmpty()) {
            return Optional.empty();
        }
        switch (version.get()) {
            case VERSION_UPROTOCOL: {
                time = uuid.getMsb() >> 16;
                break;
            }
            case VERSION_TIME_ORDERED: {
                try {
                    UUID uuid_java = new UUID(uuid.getMsb(), uuid.getLsb());
                    time = UuidTime.toUnixTimestamp((long)UuidUtil.getTimestamp((UUID)uuid_java)) / 10000L;
                    break;
                }
                catch (IllegalArgumentException e) {
                    return Optional.empty();
                }
            }
        }
        return Optional.ofNullable(time);
    }

    public static Optional<Long> getElapsedTime(org.eclipse.uprotocol.v1.UUID id) {
        long creationTime = UuidUtils.getTime(id).orElse(-1L);
        if (creationTime < 0L) {
            return Optional.empty();
        }
        long now = System.currentTimeMillis();
        return now >= creationTime ? Optional.of(now - creationTime) : Optional.empty();
    }

    public static Optional<Long> getRemainingTime(org.eclipse.uprotocol.v1.UUID id, int ttl) {
        if (id == null || ttl <= 0) {
            return Optional.empty();
        }
        return UuidUtils.getElapsedTime(id).filter(elapsedTime -> (long)ttl > elapsedTime).map(elapsedTime -> (long)ttl - elapsedTime);
    }

    public static Optional<Long> getRemainingTime(UAttributes attributes) {
        return attributes.hasTtl() ? UuidUtils.getRemainingTime(attributes.getId(), attributes.getTtl()) : Optional.empty();
    }

    public static boolean isExpired(org.eclipse.uprotocol.v1.UUID id, int ttl) {
        return ttl > 0 && UuidUtils.getRemainingTime(id, ttl).isEmpty();
    }

    public static boolean isExpired(UAttributes attributes) {
        return attributes.hasTtl() && UuidUtils.isExpired(attributes.getId(), attributes.getTtl());
    }

    public static enum Version {
        VERSION_UNKNOWN(0),
        VERSION_RANDOM_BASED(4),
        VERSION_TIME_ORDERED(6),
        VERSION_UPROTOCOL(8);

        private final int value;

        private Version(int value) {
            this.value = value;
        }

        public static Optional<Version> getVersion(int value) {
            for (Version version : Version.values()) {
                if (version.getValue() != value) continue;
                return Optional.of(version);
            }
            return Optional.empty();
        }

        public int getValue() {
            return this.value;
        }
    }
}

