/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uuid.serializer;

import java.util.UUID;
import org.eclipse.uprotocol.uuid.serializer.UuidSerializer;

public class LongUuidSerializer
implements UuidSerializer<String> {
    private static final LongUuidSerializer INSTANCE = new LongUuidSerializer();

    private LongUuidSerializer() {
    }

    public static LongUuidSerializer instance() {
        return INSTANCE;
    }

    @Override
    public org.eclipse.uprotocol.v1.UUID deserialize(String stringUuid) {
        if (stringUuid == null || stringUuid.isBlank()) {
            return org.eclipse.uprotocol.v1.UUID.getDefaultInstance();
        }
        try {
            UUID uuid_java = UUID.fromString(stringUuid);
            return org.eclipse.uprotocol.v1.UUID.newBuilder().setMsb(uuid_java.getMostSignificantBits()).setLsb(uuid_java.getLeastSignificantBits()).build();
        }
        catch (IllegalArgumentException e) {
            return org.eclipse.uprotocol.v1.UUID.getDefaultInstance();
        }
    }

    @Override
    public String serialize(org.eclipse.uprotocol.v1.UUID uuid) {
        return uuid == null ? new String() : new UUID(uuid.getMsb(), uuid.getLsb()).toString();
    }
}

