/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uuid.serializer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.uprotocol.uuid.serializer.UuidSerializer;
import org.eclipse.uprotocol.v1.UUID;

public class MicroUuidSerializer
implements UuidSerializer<byte[]> {
    private static final MicroUuidSerializer INSTANCE = new MicroUuidSerializer();

    private MicroUuidSerializer() {
    }

    public static MicroUuidSerializer instance() {
        return INSTANCE;
    }

    @Override
    public UUID deserialize(byte[] uuid) {
        if (uuid == null || uuid.length != 16) {
            return UUID.getDefaultInstance();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(uuid);
        return UUID.newBuilder().setMsb(byteBuffer.getLong()).setLsb(byteBuffer.getLong()).build();
    }

    @Override
    public byte[] serialize(UUID uuid) {
        if (uuid == null) {
            return new byte[0];
        }
        byte[] b = new byte[16];
        return ByteBuffer.wrap(b).order(ByteOrder.BIG_ENDIAN).putLong(uuid.getMsb()).putLong(uuid.getLsb()).array();
    }
}

