/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.uuid.validate;

import com.github.f4b6a3.uuid.enums.UuidVariant;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.uprotocol.uuid.factory.UuidUtils;
import org.eclipse.uprotocol.v1.UCode;
import org.eclipse.uprotocol.v1.UStatus;
import org.eclipse.uprotocol.v1.UUID;
import org.eclipse.uprotocol.validation.ValidationResult;

public abstract class UuidValidator {
    public static UuidValidator getValidator(UUID uuid) {
        if (UuidUtils.isUuidv6(uuid)) {
            return Validators.UUIDV6.validator();
        }
        if (UuidUtils.isUProtocol(uuid)) {
            return Validators.UPROTOCOL.validator();
        }
        return Validators.UNKNOWN.validator();
    }

    public UStatus validate(UUID uuid) {
        String errorMessage = Stream.of(this.validateVersion(uuid), this.validateVariant(uuid), this.validateTime(uuid)).filter(ValidationResult::isFailure).map(ValidationResult::getMessage).collect(Collectors.joining(","));
        return errorMessage.isBlank() ? ValidationResult.success().toStatus() : UStatus.newBuilder().setCode(UCode.INVALID_ARGUMENT).setMessage(errorMessage).build();
    }

    public abstract ValidationResult validateVersion(UUID var1);

    public ValidationResult validateTime(UUID uuid) {
        Optional<Long> time = UuidUtils.getTime(uuid);
        return time.isPresent() && time.get() > 0L ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid UUID Time", new Object[0]));
    }

    public abstract ValidationResult validateVariant(UUID var1);

    private static class UUIDv8Validator
    extends UuidValidator {
        private UUIDv8Validator() {
        }

        @Override
        public ValidationResult validateVersion(UUID uuid) {
            Optional<UuidUtils.Version> version = UuidUtils.getVersion(uuid);
            return version.isPresent() && version.get() == UuidUtils.Version.VERSION_UPROTOCOL ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid UUIDv8 Version", new Object[0]));
        }

        @Override
        public ValidationResult validateVariant(UUID uuid) {
            return ValidationResult.success();
        }
    }

    private static class UUIDv6Validator
    extends UuidValidator {
        private UUIDv6Validator() {
        }

        @Override
        public ValidationResult validateVersion(UUID uuid) {
            Optional<UuidUtils.Version> version = UuidUtils.getVersion(uuid);
            return version.isPresent() && version.get() == UuidUtils.Version.VERSION_TIME_ORDERED ? ValidationResult.success() : ValidationResult.failure(String.format("Not a UUIDv6 Version", new Object[0]));
        }

        @Override
        public ValidationResult validateVariant(UUID uuid) {
            Optional<Integer> variant = UuidUtils.getVariant(uuid);
            return variant.isPresent() && variant.get().intValue() == UuidVariant.VARIANT_RFC_4122.getValue() ? ValidationResult.success() : ValidationResult.failure(String.format("Invalid UUIDv6 variant", new Object[0]));
        }
    }

    private static class InvalidValidator
    extends UuidValidator {
        private InvalidValidator() {
        }

        @Override
        public ValidationResult validateVersion(UUID uuid) {
            return ValidationResult.failure(String.format("Invalid UUID Version", new Object[0]));
        }

        @Override
        public ValidationResult validateVariant(UUID uuid) {
            return ValidationResult.failure(String.format("Invalid UUID Variant", new Object[0]));
        }
    }

    public static enum Validators {
        UNKNOWN(new InvalidValidator()),
        UUIDV6(new UUIDv6Validator()),
        UPROTOCOL(new UUIDv8Validator());

        private final UuidValidator uuidValidator;

        public UuidValidator validator() {
            return this.uuidValidator;
        }

        private Validators(UuidValidator uuidValidator) {
            this.uuidValidator = uuidValidator;
        }
    }
}

