/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uprotocol.validation;

import java.util.Objects;
import org.eclipse.uprotocol.v1.UCode;
import org.eclipse.uprotocol.v1.UStatus;

public abstract class ValidationResult {
    public static final UStatus STATUS_SUCCESS = UStatus.newBuilder().setCode(UCode.OK).setMessage("OK").build();
    private static final ValidationResult SUCCESS = new Success();

    private ValidationResult() {
    }

    public abstract UStatus toStatus();

    public abstract boolean isSuccess();

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public abstract String getMessage();

    public static ValidationResult success() {
        return SUCCESS;
    }

    public static ValidationResult failure(String message) {
        return new Failure(message);
    }

    private static class Success
    extends ValidationResult {
        private Success() {
        }

        @Override
        public UStatus toStatus() {
            return STATUS_SUCCESS;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public String getMessage() {
            return "";
        }

        public String toString() {
            return "ValidationResult.Success()";
        }
    }

    private static class Failure
    extends ValidationResult {
        private final String message;

        private Failure(String message) {
            this.message = Objects.requireNonNullElse(message, "Validation Failed.");
        }

        @Override
        public UStatus toStatus() {
            return UStatus.newBuilder().setCode(UCode.INVALID_ARGUMENT).setMessage(this.message).build();
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ValidationResult.Failure(message='" + this.message + "')";
        }
    }
}

