/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.billing.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum Currency {
    USD("USD"),
    EUR("EUR"),
    CNY("CNY");

    private final String value;

    private Currency(String value) {
        this.value = value;
    }

    @JsonCreator
    public static Currency getByValue(String value) {
        for (Currency enumeration : Currency.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)enumeration.value, (CharSequence)value)) continue;
            return enumeration;
        }
        throw new UnsupportedEnumValueException(String.format("Currency value %s is not supported.", value));
    }

    @JsonValue
    public String toValue() {
        return this.value;
    }
}

