/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.common.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum Category {
    AI("ai"),
    COMPUTE("compute"),
    CONTAINER("container"),
    STORAGE("storage"),
    NETWORK("network"),
    DATABASE("database"),
    MEDIA_SERVICE("mediaService"),
    SECURITY("security"),
    MIDDLEWARE("middleware"),
    OTHERS("others");

    private final String catalog;

    private Category(String catalog) {
        this.catalog = catalog;
    }

    @JsonCreator
    public static Category getByValue(String catalog) {
        for (Category category : Category.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)category.catalog, (CharSequence)catalog)) continue;
            return category;
        }
        throw new UnsupportedEnumValueException(String.format("Category value %s is not supported.", catalog));
    }

    @JsonValue
    public String toValue() {
        return this.catalog;
    }
}

