/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.common.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum Csp {
    HUAWEI_CLOUD("HuaweiCloud"),
    FLEXIBLE_ENGINE("FlexibleEngine"),
    OPENSTACK_TESTLAB("OpenstackTestlab"),
    PLUS_SERVER("PlusServer"),
    REGIO_CLOUD("RegioCloud"),
    ALIBABA_CLOUD("AlibabaCloud"),
    AWS("aws"),
    AZURE("azure"),
    GCP("GoogleCloudPlatform");

    private final String value;

    private Csp(String value) {
        this.value = value;
    }

    @JsonCreator
    public static Csp getByValue(String name) {
        for (Csp csp : Csp.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)csp.value, (CharSequence)name)) continue;
            return csp;
        }
        throw new UnsupportedEnumValueException(String.format("Csp value %s is not supported.", name));
    }

    @JsonValue
    public String toValue() {
        return this.value;
    }
}

