/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.credential;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.common.enums.Csp;
import org.eclipse.xpanse.modules.models.credential.CredentialVariables;
import org.eclipse.xpanse.modules.models.credential.config.AbstractCredentialInfoDeserializer;
import org.eclipse.xpanse.modules.models.credential.enums.CredentialType;

@Schema(allOf={CredentialVariables.class})
@JsonDeserialize(using=AbstractCredentialInfoDeserializer.class)
public abstract class AbstractCredentialInfo {
    @NotNull
    @Schema(description="The cloud service provider of the credential.")
    Csp csp;
    @NotNull
    @NotBlank
    @Schema(description="The site which the credentials belong to.")
    String site;
    @NotNull
    @Schema(description="The type of the credential, this field is provided by the plugin of cloud service provider.")
    CredentialType type;
    @NotNull
    @NotBlank
    @Schema(description="The name of the credential, this field is provided by the plugin of cloud service provider. The value of this field must be unique between credentials with the same csp and type.")
    String name;
    @NotNull
    @NotBlank
    @Schema(description="The description of the credential,this field is provided by the plugin of cloud service provider.")
    String description;
    @Schema(description="The id of user who created the credential.")
    String userId;
    @Hidden
    @Schema(description="The time in seconds to live of the credential")
    Integer timeToLive;

    AbstractCredentialInfo(Csp csp, String site, CredentialType type, String name, String description, String userId) {
        this.csp = csp;
        this.site = site;
        this.type = type;
        this.name = name;
        this.description = description;
        this.userId = userId;
    }

    @Hidden
    public String getUniqueKey() {
        return this.csp.name() + "-" + this.site + "-" + this.type.name() + "-" + this.name;
    }

    @Generated
    public Csp getCsp() {
        return this.csp;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public CredentialType getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    @Generated
    public void setCsp(Csp csp) {
        this.csp = csp;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
    }
}

