/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.credential;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.common.enums.Csp;
import org.eclipse.xpanse.modules.models.credential.CredentialVariable;
import org.eclipse.xpanse.modules.models.credential.enums.CredentialType;
import org.hibernate.validator.constraints.UniqueElements;

public class CreateCredential {
    @NotNull
    @NotBlank
    @Schema(description="The name of the credential")
    private String name;
    @Hidden
    private String userId;
    @NotNull
    @Schema(description="The cloud service provider of the credential.")
    private Csp csp;
    @NotNull
    @NotEmpty
    @Schema(description="The site to which the credentials belong to.")
    private String site;
    @Schema(description="The description of the credential")
    private String description;
    @NotNull
    @Schema(description="The type of the credential")
    private CredentialType type;
    @NotNull
    @NotEmpty
    @UniqueElements
    @Schema(description="The variables list of the credential. The list elements must be unique.")
    private List<CredentialVariable> variables;
    @NotNull
    @Schema(description="The time in seconds to live of the credential", defaultValue="3600")
    private Integer timeToLive = 3600;

    @Generated
    public CreateCredential() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public Csp getCsp() {
        return this.csp;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public CredentialType getType() {
        return this.type;
    }

    @Generated
    public List<CredentialVariable> getVariables() {
        return this.variables;
    }

    @Generated
    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setCsp(Csp csp) {
        this.csp = csp;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setType(CredentialType type) {
        this.type = type;
    }

    @Generated
    public void setVariables(List<CredentialVariable> variables) {
        this.variables = variables;
    }

    @Generated
    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateCredential)) {
            return false;
        }
        CreateCredential other = (CreateCredential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$timeToLive = this.getTimeToLive();
        Integer other$timeToLive = other.getTimeToLive();
        if (this$timeToLive == null ? other$timeToLive != null : !((Object)this$timeToLive).equals(other$timeToLive)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Csp this$csp = this.getCsp();
        Csp other$csp = other.getCsp();
        if (this$csp == null ? other$csp != null : !((Object)((Object)this$csp)).equals((Object)other$csp)) {
            return false;
        }
        String this$site = this.getSite();
        String other$site = other.getSite();
        if (this$site == null ? other$site != null : !this$site.equals(other$site)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        CredentialType this$type = this.getType();
        CredentialType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<CredentialVariable> this$variables = this.getVariables();
        List<CredentialVariable> other$variables = other.getVariables();
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateCredential;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $timeToLive = this.getTimeToLive();
        result = result * 59 + ($timeToLive == null ? 43 : ((Object)$timeToLive).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Csp $csp = this.getCsp();
        result = result * 59 + ($csp == null ? 43 : ((Object)((Object)$csp)).hashCode());
        String $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : $site.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        CredentialType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<CredentialVariable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CreateCredential(name=" + this.getName() + ", userId=" + this.getUserId() + ", csp=" + String.valueOf((Object)this.getCsp()) + ", site=" + this.getSite() + ", description=" + this.getDescription() + ", type=" + String.valueOf((Object)this.getType()) + ", variables=" + String.valueOf(this.getVariables()) + ", timeToLive=" + this.getTimeToLive() + ")";
    }
}

