/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.credential;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.credential.config.CredentialVariableDeserializer;

@JsonDeserialize(using=CredentialVariableDeserializer.class)
public class CredentialVariable {
    @NotNull
    @Schema(description="The name of the CredentialVariable,this field is provided by the plugin of cloud service provider.")
    private final String name;
    @NotNull
    @Schema(description="The description of the CredentialVariable,this field is provided by the plugin of cloud service provider.")
    private final String description;
    @Schema(description="If the variable is mandatory. If is optional then the credential completeness check will ignore this variable. It is upto the plugin to decide what needs to be done if this optional credential variable is present.", defaultValue="true")
    private final Boolean isMandatory;
    @NotNull
    @Schema(description="Defines if the particular variable contains sensitive data. For example the value is false for username and true for password variables respectively.")
    private final Boolean isSensitive;
    @NotNull
    @NotBlank
    @Schema(description="The value of the CredentialVariable, this field is filled by the user.")
    private String value;

    public CredentialVariable(String name, String description, Boolean isSensitive) {
        this.name = name;
        this.description = description;
        this.isMandatory = true;
        this.isSensitive = isSensitive;
    }

    public CredentialVariable(String name, String description, Boolean isMandatory, Boolean isSensitive) {
        this.name = name;
        this.description = description;
        this.isMandatory = isMandatory;
        this.isSensitive = isSensitive;
    }

    public CredentialVariable(String name, String description, Boolean isMandatory, Boolean isSensitive, String value) {
        this.name = name;
        this.description = description;
        this.isMandatory = isMandatory;
        this.isSensitive = isSensitive;
        this.value = value;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getIsMandatory() {
        return this.isMandatory;
    }

    @Generated
    public Boolean getIsSensitive() {
        return this.isSensitive;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CredentialVariable)) {
            return false;
        }
        CredentialVariable other = (CredentialVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isMandatory = this.getIsMandatory();
        Boolean other$isMandatory = other.getIsMandatory();
        if (this$isMandatory == null ? other$isMandatory != null : !((Object)this$isMandatory).equals(other$isMandatory)) {
            return false;
        }
        Boolean this$isSensitive = this.getIsSensitive();
        Boolean other$isSensitive = other.getIsSensitive();
        if (this$isSensitive == null ? other$isSensitive != null : !((Object)this$isSensitive).equals(other$isSensitive)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CredentialVariable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isMandatory = this.getIsMandatory();
        result = result * 59 + ($isMandatory == null ? 43 : ((Object)$isMandatory).hashCode());
        Boolean $isSensitive = this.getIsSensitive();
        result = result * 59 + ($isSensitive == null ? 43 : ((Object)$isSensitive).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CredentialVariable(name=" + this.getName() + ", description=" + this.getDescription() + ", isMandatory=" + this.getIsMandatory() + ", isSensitive=" + this.getIsSensitive() + ", value=" + this.getValue() + ")";
    }
}

