/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.common.enums.Csp;
import org.eclipse.xpanse.modules.models.credential.AbstractCredentialInfo;
import org.eclipse.xpanse.modules.models.credential.CreateCredential;
import org.eclipse.xpanse.modules.models.credential.CredentialVariable;
import org.eclipse.xpanse.modules.models.credential.enums.CredentialType;

public class CredentialVariables
extends AbstractCredentialInfo {
    @NotNull
    @Size(min=1)
    @Schema(description="The variables list of the credential.")
    private final @NotNull @Size(min=1) List<CredentialVariable> variables;

    public CredentialVariables(Csp csp, String site, CredentialType type, String name, String description, String userId, List<CredentialVariable> variables) {
        super(csp, site, type, name, description, userId);
        this.variables = variables;
    }

    @JsonCreator
    public CredentialVariables(@JsonProperty(value="csp") Csp csp, @JsonProperty(value="site") String site, @JsonProperty(value="type") CredentialType type, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="userId") String userId, @JsonProperty(value="timeToLive") Integer timeToLive, @JsonProperty(value="variables") List<CredentialVariable> variables) {
        super(csp, site, type, name, description, userId);
        this.timeToLive = timeToLive;
        this.variables = variables;
    }

    public CredentialVariables(CreateCredential createCredential) {
        super(createCredential.getCsp(), createCredential.getSite(), createCredential.getType(), createCredential.getName(), createCredential.getDescription(), createCredential.getUserId());
        this.timeToLive = createCredential.getTimeToLive();
        this.variables = createCredential.getVariables();
    }

    @Generated
    public List<CredentialVariable> getVariables() {
        return this.variables;
    }
}

