/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.credential.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.common.enums.Csp;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;
import org.eclipse.xpanse.modules.models.credential.AbstractCredentialInfo;
import org.eclipse.xpanse.modules.models.credential.CredentialVariable;
import org.eclipse.xpanse.modules.models.credential.CredentialVariables;
import org.eclipse.xpanse.modules.models.credential.config.CredentialVariableDeserializer;
import org.eclipse.xpanse.modules.models.credential.enums.CredentialType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCredentialInfoDeserializer
extends StdDeserializer<AbstractCredentialInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCredentialInfoDeserializer.class);

    public AbstractCredentialInfoDeserializer() {
        this(AbstractCredentialInfo.class);
    }

    public AbstractCredentialInfoDeserializer(Class<?> deserializedClass) {
        super(deserializedClass);
    }

    public AbstractCredentialInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        CredentialType type;
        Csp csp;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        try {
            csp = Csp.getByValue(node.get("csp").asText());
        }
        catch (Exception e) {
            log.error("Unsupported csp value: {}", (Object)node.get("csp").asText());
            return null;
        }
        try {
            type = CredentialType.getByValue(node.get("type").asText());
        }
        catch (UnsupportedEnumValueException e) {
            log.error("Unsupported credential type: {}", (Object)node.get("type").asText());
            return null;
        }
        try {
            String site = this.safeGet(node, "site", JsonNode::asText);
            String name = this.safeGet(node, "name", JsonNode::asText);
            String description = this.safeGet(node, "description", JsonNode::asText);
            String userId = this.safeGet(node, "userId", JsonNode::asText);
            Integer timeToLive = this.safeGet(node, "timeToLive", JsonNode::asInt);
            List<CredentialVariable> variables = this.deserializeCredentialVariables(node.get("variables"));
            return new CredentialVariables(csp, site, type, name, description, userId, timeToLive, variables);
        }
        catch (Exception e) {
            log.error("IllegalArgumentException: {}", (Object)e.getMessage());
            return null;
        }
    }

    private <T> T safeGet(JsonNode node, String fieldName, Function<JsonNode, T> mapper) {
        if (node == null || node.get(fieldName) == null) {
            return null;
        }
        try {
            return mapper.apply(node.get(fieldName));
        }
        catch (Exception e) {
            log.error("Failed to map field {} due to: {}", (Object)fieldName, (Object)e.getMessage());
            return null;
        }
    }

    private List<CredentialVariable> deserializeCredentialVariables(JsonNode node) {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(CredentialVariable.class, (JsonDeserializer)new CredentialVariableDeserializer());
        mapper.registerModule((Module)module);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List credentialVariable = null;
        try {
            credentialVariable = (List)mapper.convertValue((Object)node, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, CredentialVariable.class));
        }
        catch (IllegalArgumentException e) {
            log.error("Deserialize CredentialVariables with value:{} failed.", (Object)node, (Object)e);
        }
        return credentialVariable;
    }
}

