/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.credential.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum CredentialType {
    VARIABLES("variables"),
    HTTP_AUTHENTICATION("http_authentication"),
    API_KEY("api_key"),
    OAUTH2("oauth2");

    private final String type;

    private CredentialType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static CredentialType getByValue(String type) {
        for (CredentialType credentialType : CredentialType.values()) {
            if (!credentialType.type.equals(StringUtils.lowerCase((String)type))) continue;
            return credentialType;
        }
        throw new UnsupportedEnumValueException(String.format("CredentialType value %s is not supported.", type));
    }

    @JsonValue
    public String toValue() {
        return this.type;
    }
}

