/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.credential.enums;

import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;
import org.eclipse.xpanse.modules.models.credential.enums.CredentialType;

public enum CredentialTypeMessage {
    VARIABLES_MESSAGE(CredentialType.VARIABLES, "value to be provided by creating credential or adding environment variables."),
    HTTP_AUTHENTICATION_MESSAGE(CredentialType.HTTP_AUTHENTICATION, null),
    API_KEY_MESSAGE(CredentialType.API_KEY, null),
    OAUTH2_MESSAGE(CredentialType.OAUTH2, null);

    private final String message;
    private final CredentialType type;

    private CredentialTypeMessage(CredentialType type, String message) {
        this.type = type;
        this.message = message;
    }

    public static String getMessageByType(CredentialType type) {
        for (CredentialTypeMessage typeMessage : CredentialTypeMessage.values()) {
            if (typeMessage.type != type) continue;
            return typeMessage.message;
        }
        throw new UnsupportedEnumValueException(String.format("CredentialTypeMessage value %s is not supported.", new Object[]{type}));
    }
}

