/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.monitor.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum MetricItemType {
    VALUE("value"),
    COUNT("count"),
    SUM("sum");

    private final String type;

    private MetricItemType(String type) {
        this.type = type;
    }

    @JsonCreator
    public MetricItemType getByValue(String type) {
        for (MetricItemType metricsItemType : MetricItemType.values()) {
            if (!metricsItemType.type.equals(StringUtils.lowerCase((String)type))) continue;
            return metricsItemType;
        }
        throw new UnsupportedEnumValueException(String.format("MetricItemType value %s is not supported.", type));
    }

    @JsonValue
    public String toValue() {
        return this.type;
    }
}

