/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.monitor.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum MetricType {
    COUNTER("counter"),
    GAUGE("gauge"),
    HISTOGRAM("histogram"),
    SUMMARY("summary");

    private final String type;

    private MetricType(String type) {
        this.type = type;
    }

    @JsonCreator
    public MetricType getByValue(String type) {
        for (MetricType metricsType : MetricType.values()) {
            if (!metricsType.type.equals(StringUtils.lowerCase((String)type))) continue;
            return metricsType;
        }
        throw new UnsupportedEnumValueException(String.format("MetricType value %s is not supported.", type));
    }

    @JsonValue
    public String toValue() {
        return this.type;
    }
}

