/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.monitor.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum MetricUnit {
    MB("mb"),
    KB("kb"),
    PERCENTAGE("percentage"),
    BITS_PER_SECOND("bit/s"),
    BYTES_PER_SECOND("Byte/s");

    private final String type;

    private MetricUnit(String type) {
        this.type = type;
    }

    @JsonCreator
    public static MetricUnit getByValue(String type) {
        for (MetricUnit metricUnit : MetricUnit.values()) {
            if (!metricUnit.type.equals(StringUtils.lowerCase((String)type))) continue;
            return metricUnit;
        }
        throw new UnsupportedEnumValueException(String.format("MetricUnit value %s is not supported.", type));
    }

    @JsonValue
    public String toValue() {
        return this.type;
    }
}

