/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.policy.servicepolicy;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class ServicePolicy {
    @NotNull
    @Schema(description="The id of the policy.")
    private UUID servicePolicyId;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="The valid policy belongs to the service.")
    private String policy;
    @NotNull
    @Schema(description="The id of registered service template which the policy belongs to.")
    private UUID serviceTemplateId;
    @Schema(description="The flavor name list which the policy belongs to. If the list is empty, then the policy will be executed for during service deployment of all flavors.")
    private List<String> flavorNameList;
    @NotNull
    @Schema(description="Is the policy enabled.")
    private Boolean enabled;
    @NotNull
    @Schema(description="Time of the policy created.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime createTime;
    @NotNull
    @Schema(description="Time of the policy updated.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime lastModifiedTime;

    @Generated
    public ServicePolicy() {
    }

    @Generated
    public UUID getServicePolicyId() {
        return this.servicePolicyId;
    }

    @Generated
    public String getPolicy() {
        return this.policy;
    }

    @Generated
    public UUID getServiceTemplateId() {
        return this.serviceTemplateId;
    }

    @Generated
    public List<String> getFlavorNameList() {
        return this.flavorNameList;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public OffsetDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public void setServicePolicyId(UUID servicePolicyId) {
        this.servicePolicyId = servicePolicyId;
    }

    @Generated
    public void setPolicy(String policy) {
        this.policy = policy;
    }

    @Generated
    public void setServiceTemplateId(UUID serviceTemplateId) {
        this.serviceTemplateId = serviceTemplateId;
    }

    @Generated
    public void setFlavorNameList(List<String> flavorNameList) {
        this.flavorNameList = flavorNameList;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServicePolicy)) {
            return false;
        }
        ServicePolicy other = (ServicePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        UUID this$servicePolicyId = this.getServicePolicyId();
        UUID other$servicePolicyId = other.getServicePolicyId();
        if (this$servicePolicyId == null ? other$servicePolicyId != null : !((Object)this$servicePolicyId).equals(other$servicePolicyId)) {
            return false;
        }
        String this$policy = this.getPolicy();
        String other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !this$policy.equals(other$policy)) {
            return false;
        }
        UUID this$serviceTemplateId = this.getServiceTemplateId();
        UUID other$serviceTemplateId = other.getServiceTemplateId();
        if (this$serviceTemplateId == null ? other$serviceTemplateId != null : !((Object)this$serviceTemplateId).equals(other$serviceTemplateId)) {
            return false;
        }
        List<String> this$flavorNameList = this.getFlavorNameList();
        List<String> other$flavorNameList = other.getFlavorNameList();
        if (this$flavorNameList == null ? other$flavorNameList != null : !((Object)this$flavorNameList).equals(other$flavorNameList)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        OffsetDateTime this$lastModifiedTime = this.getLastModifiedTime();
        OffsetDateTime other$lastModifiedTime = other.getLastModifiedTime();
        return !(this$lastModifiedTime == null ? other$lastModifiedTime != null : !((Object)this$lastModifiedTime).equals(other$lastModifiedTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServicePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        UUID $servicePolicyId = this.getServicePolicyId();
        result = result * 59 + ($servicePolicyId == null ? 43 : ((Object)$servicePolicyId).hashCode());
        String $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : $policy.hashCode());
        UUID $serviceTemplateId = this.getServiceTemplateId();
        result = result * 59 + ($serviceTemplateId == null ? 43 : ((Object)$serviceTemplateId).hashCode());
        List<String> $flavorNameList = this.getFlavorNameList();
        result = result * 59 + ($flavorNameList == null ? 43 : ((Object)$flavorNameList).hashCode());
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        OffsetDateTime $lastModifiedTime = this.getLastModifiedTime();
        result = result * 59 + ($lastModifiedTime == null ? 43 : ((Object)$lastModifiedTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServicePolicy(servicePolicyId=" + String.valueOf(this.getServicePolicyId()) + ", policy=" + this.getPolicy() + ", serviceTemplateId=" + String.valueOf(this.getServiceTemplateId()) + ", flavorNameList=" + String.valueOf(this.getFlavorNameList()) + ", enabled=" + this.getEnabled() + ", createTime=" + String.valueOf(this.getCreateTime()) + ", lastModifiedTime=" + String.valueOf(this.getLastModifiedTime()) + ")";
    }
}

