/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.policy.userpolicy;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.common.enums.Csp;

public class UserPolicy {
    @NotNull
    @Schema(description="The id of the policy.")
    private UUID userPolicyId;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="The valid policy created by the user.")
    private String policy;
    @NotNull
    @Schema(description="The csp which the policy belongs to.")
    private Csp csp;
    @NotNull
    @Schema(description="Is the policy enabled.")
    private Boolean enabled;
    @NotNull
    @Schema(description="Time of the policy created.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime createTime;
    @NotNull
    @Schema(description="Time of the policy updated.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime lastModifiedTime;

    @Generated
    public UserPolicy() {
    }

    @Generated
    public UUID getUserPolicyId() {
        return this.userPolicyId;
    }

    @Generated
    public String getPolicy() {
        return this.policy;
    }

    @Generated
    public Csp getCsp() {
        return this.csp;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public OffsetDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public void setUserPolicyId(UUID userPolicyId) {
        this.userPolicyId = userPolicyId;
    }

    @Generated
    public void setPolicy(String policy) {
        this.policy = policy;
    }

    @Generated
    public void setCsp(Csp csp) {
        this.csp = csp;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPolicy)) {
            return false;
        }
        UserPolicy other = (UserPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        UUID this$userPolicyId = this.getUserPolicyId();
        UUID other$userPolicyId = other.getUserPolicyId();
        if (this$userPolicyId == null ? other$userPolicyId != null : !((Object)this$userPolicyId).equals(other$userPolicyId)) {
            return false;
        }
        String this$policy = this.getPolicy();
        String other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !this$policy.equals(other$policy)) {
            return false;
        }
        Csp this$csp = this.getCsp();
        Csp other$csp = other.getCsp();
        if (this$csp == null ? other$csp != null : !((Object)((Object)this$csp)).equals((Object)other$csp)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        OffsetDateTime this$lastModifiedTime = this.getLastModifiedTime();
        OffsetDateTime other$lastModifiedTime = other.getLastModifiedTime();
        return !(this$lastModifiedTime == null ? other$lastModifiedTime != null : !((Object)this$lastModifiedTime).equals(other$lastModifiedTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        UUID $userPolicyId = this.getUserPolicyId();
        result = result * 59 + ($userPolicyId == null ? 43 : ((Object)$userPolicyId).hashCode());
        String $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : $policy.hashCode());
        Csp $csp = this.getCsp();
        result = result * 59 + ($csp == null ? 43 : ((Object)((Object)$csp)).hashCode());
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        OffsetDateTime $lastModifiedTime = this.getLastModifiedTime();
        result = result * 59 + ($lastModifiedTime == null ? 43 : ((Object)$lastModifiedTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserPolicy(userPolicyId=" + String.valueOf(this.getUserPolicyId()) + ", policy=" + this.getPolicy() + ", csp=" + String.valueOf((Object)this.getCsp()) + ", enabled=" + this.getEnabled() + ", createTime=" + String.valueOf(this.getCreateTime()) + ", lastModifiedTime=" + String.valueOf(this.getLastModifiedTime()) + ")";
    }
}

