/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.response.ResultType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Response {
    @NotNull
    @Schema(description="The result code of response.")
    private ResultType resultType;
    @NotNull
    @NotEmpty
    @Schema(description="Details of the errors occurred")
    private List<String> details;
    @NotNull
    @Schema(description="Describes if the request is successful")
    private Boolean success;

    Response() {
    }

    public static Response errorResponse(ResultType resultCode, List<String> errMsg) {
        Response response = new Response();
        response.success = false;
        response.resultType = resultCode;
        response.details = errMsg;
        return response;
    }

    @Generated
    public ResultType getResultType() {
        return this.resultType;
    }

    @Generated
    public List<String> getDetails() {
        return this.details;
    }

    @Generated
    public Boolean getSuccess() {
        return this.success;
    }

    @Generated
    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    @Generated
    public void setDetails(List<String> details) {
        this.details = details;
    }

    @Generated
    public void setSuccess(Boolean success) {
        this.success = success;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        ResultType this$resultType = this.getResultType();
        ResultType other$resultType = other.getResultType();
        if (this$resultType == null ? other$resultType != null : !((Object)((Object)this$resultType)).equals((Object)other$resultType)) {
            return false;
        }
        List<String> this$details = this.getDetails();
        List<String> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        ResultType $resultType = this.getResultType();
        result = result * 59 + ($resultType == null ? 43 : ((Object)((Object)$resultType)).hashCode());
        List<String> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Response(resultType=" + String.valueOf((Object)this.getResultType()) + ", details=" + String.valueOf(this.getDetails()) + ", success=" + this.getSuccess() + ")";
    }
}

