/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.deploy;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.billing.enums.BillingMode;
import org.eclipse.xpanse.modules.models.common.enums.Category;
import org.eclipse.xpanse.modules.models.common.enums.Csp;
import org.eclipse.xpanse.modules.models.servicetemplate.Region;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.ServiceHostingType;

public class DeployRequestBase
implements Serializable {
    @Hidden
    private String userId;
    @NotNull
    @Schema(description="The category of the service")
    private Category category;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="The name of the service ordered.")
    private String serviceName;
    @Schema(description="Customer's name for the service. Used only for customer's reference.If not provided, this value will be auto-generated")
    private String customerServiceName;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="The version of service")
    private String version;
    @NotNull
    @Schema(description="The region of the provider.")
    private Region region;
    @NotNull
    @Schema(description="The csp of the Service.")
    private Csp csp;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="The flavor of the Service.")
    private String flavor;
    @NotNull
    @Schema(description="Defines which cloud service account is used for deploying cloud resources.")
    private ServiceHostingType serviceHostingType;
    @Schema(description="The properties for the requested service")
    private Map<String, Object> serviceRequestProperties;
    @Schema(description="The availability zones to deploy the service instance.")
    private Map<String, String> availabilityZones;
    @Schema(description="The flag to determine if the user has accepted the EULA terms.")
    private boolean isEulaAccepted;
    @NotNull
    @Schema(description="The billing mode of the managed service.")
    private BillingMode billingMode;

    @Generated
    public DeployRequestBase() {
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getCustomerServiceName() {
        return this.customerServiceName;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Region getRegion() {
        return this.region;
    }

    @Generated
    public Csp getCsp() {
        return this.csp;
    }

    @Generated
    public String getFlavor() {
        return this.flavor;
    }

    @Generated
    public ServiceHostingType getServiceHostingType() {
        return this.serviceHostingType;
    }

    @Generated
    public Map<String, Object> getServiceRequestProperties() {
        return this.serviceRequestProperties;
    }

    @Generated
    public Map<String, String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    @Generated
    public boolean isEulaAccepted() {
        return this.isEulaAccepted;
    }

    @Generated
    public BillingMode getBillingMode() {
        return this.billingMode;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setCategory(Category category) {
        this.category = category;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setCustomerServiceName(String customerServiceName) {
        this.customerServiceName = customerServiceName;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setRegion(Region region) {
        this.region = region;
    }

    @Generated
    public void setCsp(Csp csp) {
        this.csp = csp;
    }

    @Generated
    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    @Generated
    public void setServiceHostingType(ServiceHostingType serviceHostingType) {
        this.serviceHostingType = serviceHostingType;
    }

    @Generated
    public void setServiceRequestProperties(Map<String, Object> serviceRequestProperties) {
        this.serviceRequestProperties = serviceRequestProperties;
    }

    @Generated
    public void setAvailabilityZones(Map<String, String> availabilityZones) {
        this.availabilityZones = availabilityZones;
    }

    @Generated
    public void setEulaAccepted(boolean isEulaAccepted) {
        this.isEulaAccepted = isEulaAccepted;
    }

    @Generated
    public void setBillingMode(BillingMode billingMode) {
        this.billingMode = billingMode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployRequestBase)) {
            return false;
        }
        DeployRequestBase other = (DeployRequestBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEulaAccepted() != other.isEulaAccepted()) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Category this$category = this.getCategory();
        Category other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$customerServiceName = this.getCustomerServiceName();
        String other$customerServiceName = other.getCustomerServiceName();
        if (this$customerServiceName == null ? other$customerServiceName != null : !this$customerServiceName.equals(other$customerServiceName)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Region this$region = this.getRegion();
        Region other$region = other.getRegion();
        if (this$region == null ? other$region != null : !((Object)this$region).equals(other$region)) {
            return false;
        }
        Csp this$csp = this.getCsp();
        Csp other$csp = other.getCsp();
        if (this$csp == null ? other$csp != null : !((Object)((Object)this$csp)).equals((Object)other$csp)) {
            return false;
        }
        String this$flavor = this.getFlavor();
        String other$flavor = other.getFlavor();
        if (this$flavor == null ? other$flavor != null : !this$flavor.equals(other$flavor)) {
            return false;
        }
        ServiceHostingType this$serviceHostingType = this.getServiceHostingType();
        ServiceHostingType other$serviceHostingType = other.getServiceHostingType();
        if (this$serviceHostingType == null ? other$serviceHostingType != null : !((Object)((Object)this$serviceHostingType)).equals((Object)other$serviceHostingType)) {
            return false;
        }
        Map<String, Object> this$serviceRequestProperties = this.getServiceRequestProperties();
        Map<String, Object> other$serviceRequestProperties = other.getServiceRequestProperties();
        if (this$serviceRequestProperties == null ? other$serviceRequestProperties != null : !((Object)this$serviceRequestProperties).equals(other$serviceRequestProperties)) {
            return false;
        }
        Map<String, String> this$availabilityZones = this.getAvailabilityZones();
        Map<String, String> other$availabilityZones = other.getAvailabilityZones();
        if (this$availabilityZones == null ? other$availabilityZones != null : !((Object)this$availabilityZones).equals(other$availabilityZones)) {
            return false;
        }
        BillingMode this$billingMode = this.getBillingMode();
        BillingMode other$billingMode = other.getBillingMode();
        return !(this$billingMode == null ? other$billingMode != null : !((Object)((Object)this$billingMode)).equals((Object)other$billingMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeployRequestBase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEulaAccepted() ? 79 : 97);
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Category $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $customerServiceName = this.getCustomerServiceName();
        result = result * 59 + ($customerServiceName == null ? 43 : $customerServiceName.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Region $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : ((Object)$region).hashCode());
        Csp $csp = this.getCsp();
        result = result * 59 + ($csp == null ? 43 : ((Object)((Object)$csp)).hashCode());
        String $flavor = this.getFlavor();
        result = result * 59 + ($flavor == null ? 43 : $flavor.hashCode());
        ServiceHostingType $serviceHostingType = this.getServiceHostingType();
        result = result * 59 + ($serviceHostingType == null ? 43 : ((Object)((Object)$serviceHostingType)).hashCode());
        Map<String, Object> $serviceRequestProperties = this.getServiceRequestProperties();
        result = result * 59 + ($serviceRequestProperties == null ? 43 : ((Object)$serviceRequestProperties).hashCode());
        Map<String, String> $availabilityZones = this.getAvailabilityZones();
        result = result * 59 + ($availabilityZones == null ? 43 : ((Object)$availabilityZones).hashCode());
        BillingMode $billingMode = this.getBillingMode();
        result = result * 59 + ($billingMode == null ? 43 : ((Object)((Object)$billingMode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeployRequestBase(userId=" + this.getUserId() + ", category=" + String.valueOf((Object)this.getCategory()) + ", serviceName=" + this.getServiceName() + ", customerServiceName=" + this.getCustomerServiceName() + ", version=" + this.getVersion() + ", region=" + String.valueOf(this.getRegion()) + ", csp=" + String.valueOf((Object)this.getCsp()) + ", flavor=" + this.getFlavor() + ", serviceHostingType=" + String.valueOf((Object)this.getServiceHostingType()) + ", serviceRequestProperties=" + String.valueOf(this.getServiceRequestProperties()) + ", availabilityZones=" + String.valueOf(this.getAvailabilityZones()) + ", isEulaAccepted=" + this.isEulaAccepted() + ", billingMode=" + String.valueOf((Object)this.getBillingMode()) + ")";
    }
}

