/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum DeployResourceKind {
    VM("vm", null),
    CONTAINER("container", null),
    PUBLIC_IP("publicIP", null),
    VPC("vpc", null),
    VOLUME("volume", null),
    UNKNOWN("unknown", null),
    SECURITY_GROUP("security_group", VPC),
    SECURITY_GROUP_RULE("security_group_rule", VPC),
    KEYPAIR("keypair", null),
    SUBNET("subnet", VPC);

    private final String kind;
    private final DeployResourceKind parent;

    private DeployResourceKind(String kind, DeployResourceKind parent) {
        this.kind = kind;
        this.parent = parent;
    }

    @JsonCreator
    public static DeployResourceKind getByValue(String kind) {
        for (DeployResourceKind resourceKind : DeployResourceKind.values()) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)resourceKind.kind, (CharSequence)kind)) continue;
            return resourceKind;
        }
        throw new UnsupportedEnumValueException(String.format("DeployResourceKind value %s is not supported.", kind));
    }

    @JsonValue
    public String toValue() {
        return this.kind;
    }

    @Generated
    public DeployResourceKind getParent() {
        return this.parent;
    }
}

