/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum ServiceDeploymentState {
    DEPLOYING("deploying"),
    DEPLOY_SUCCESS("deployment successful"),
    DEPLOY_FAILED("deployment failed"),
    DESTROYING("destroying"),
    DESTROY_SUCCESS("destroy successful"),
    DESTROY_FAILED("destroy failed"),
    MANUAL_CLEANUP_REQUIRED("manual cleanup required"),
    ROLLBACK_FAILED("rollback failed"),
    MODIFYING("modifying"),
    MODIFICATION_FAILED("modification failed"),
    MODIFICATION_SUCCESSFUL("modification successful");

    private final String state;

    private ServiceDeploymentState(String state) {
        this.state = state;
    }

    @JsonCreator
    public static ServiceDeploymentState getByValue(String state) {
        for (ServiceDeploymentState serviceState : ServiceDeploymentState.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)serviceState.state, (CharSequence)state)) continue;
            return serviceState;
        }
        throw new UnsupportedEnumValueException(String.format("ServiceDeploymentState value %s is not supported.", state));
    }

    @JsonValue
    public String toValue() {
        return this.state;
    }
}

