/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum TaskStatus {
    CREATED("created"),
    IN_PROGRESS("in progress"),
    SUCCESSFUL("successful"),
    FAILED("failed");

    private final String value;

    private TaskStatus(String value) {
        this.value = value;
    }

    @JsonCreator
    public static TaskStatus getByValue(String value) {
        for (TaskStatus entry : TaskStatus.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entry.value, (CharSequence)value)) continue;
            return entry;
        }
        throw new UnsupportedEnumValueException(String.format("WorkFlowTaskStatus value %s is not supported.", value));
    }

    @JsonValue
    public String toValue() {
        return this.value;
    }
}

