/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.service.deploy.DeployRequest;
import org.eclipse.xpanse.modules.models.service.deploy.DeployResource;
import org.eclipse.xpanse.modules.models.service.enums.TaskStatus;
import org.eclipse.xpanse.modules.models.service.order.enums.ServiceOrderType;

public class ServiceOrderDetails {
    @NotNull
    @Schema(description="The id of the service order.")
    private UUID orderId;
    @NotNull
    @Schema(description="The id of the deployed service.")
    private UUID serviceId;
    @NotNull
    @Schema(description="The task type of the service order.")
    private ServiceOrderType taskType;
    @NotNull
    @Schema(description="The task status of the service order.")
    private TaskStatus taskStatus;
    @Schema(description="The id of the original service.")
    private UUID originalServiceId;
    @Schema(description="The id of the parent service order.")
    private UUID parentOrderId;
    @Schema(description="The id of the workflow.")
    private String workflowId;
    @Schema(description="The error message if the service order task failed.")
    private String errorMsg;
    @Schema(description="The id of the user who created the service order.")
    private String userId;
    @Schema(description="The started time of the service order.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime startedTime;
    @Schema(description="The completed time of the service order.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime completedTime;
    @Schema(description="The request json of the service order.")
    private Object requestBody;
    @Schema(description="The deploy request of the service before this service order.")
    private DeployRequest previousDeployRequest;
    @Schema(description="The deploy request of the service from this service order.")
    private DeployRequest newDeployRequest;
    @Schema(description="The deployed resources of the service before this service order.")
    private List<DeployResource> previousDeployedResources;
    @Schema(description="The properties of the deployed service before this service order.")
    private Map<String, String> previousDeployedServiceProperties;
    @Schema(description="The properties of the deployed result before this service order.")
    private Map<String, String> previousDeployedResultProperties;

    @Generated
    public ServiceOrderDetails() {
    }

    @Generated
    public UUID getOrderId() {
        return this.orderId;
    }

    @Generated
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Generated
    public ServiceOrderType getTaskType() {
        return this.taskType;
    }

    @Generated
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    @Generated
    public UUID getOriginalServiceId() {
        return this.originalServiceId;
    }

    @Generated
    public UUID getParentOrderId() {
        return this.parentOrderId;
    }

    @Generated
    public String getWorkflowId() {
        return this.workflowId;
    }

    @Generated
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public OffsetDateTime getStartedTime() {
        return this.startedTime;
    }

    @Generated
    public OffsetDateTime getCompletedTime() {
        return this.completedTime;
    }

    @Generated
    public Object getRequestBody() {
        return this.requestBody;
    }

    @Generated
    public DeployRequest getPreviousDeployRequest() {
        return this.previousDeployRequest;
    }

    @Generated
    public DeployRequest getNewDeployRequest() {
        return this.newDeployRequest;
    }

    @Generated
    public List<DeployResource> getPreviousDeployedResources() {
        return this.previousDeployedResources;
    }

    @Generated
    public Map<String, String> getPreviousDeployedServiceProperties() {
        return this.previousDeployedServiceProperties;
    }

    @Generated
    public Map<String, String> getPreviousDeployedResultProperties() {
        return this.previousDeployedResultProperties;
    }

    @Generated
    public void setOrderId(UUID orderId) {
        this.orderId = orderId;
    }

    @Generated
    public void setServiceId(UUID serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setTaskType(ServiceOrderType taskType) {
        this.taskType = taskType;
    }

    @Generated
    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    @Generated
    public void setOriginalServiceId(UUID originalServiceId) {
        this.originalServiceId = originalServiceId;
    }

    @Generated
    public void setParentOrderId(UUID parentOrderId) {
        this.parentOrderId = parentOrderId;
    }

    @Generated
    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    @Generated
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setStartedTime(OffsetDateTime startedTime) {
        this.startedTime = startedTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setCompletedTime(OffsetDateTime completedTime) {
        this.completedTime = completedTime;
    }

    @Generated
    public void setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
    }

    @Generated
    public void setPreviousDeployRequest(DeployRequest previousDeployRequest) {
        this.previousDeployRequest = previousDeployRequest;
    }

    @Generated
    public void setNewDeployRequest(DeployRequest newDeployRequest) {
        this.newDeployRequest = newDeployRequest;
    }

    @Generated
    public void setPreviousDeployedResources(List<DeployResource> previousDeployedResources) {
        this.previousDeployedResources = previousDeployedResources;
    }

    @Generated
    public void setPreviousDeployedServiceProperties(Map<String, String> previousDeployedServiceProperties) {
        this.previousDeployedServiceProperties = previousDeployedServiceProperties;
    }

    @Generated
    public void setPreviousDeployedResultProperties(Map<String, String> previousDeployedResultProperties) {
        this.previousDeployedResultProperties = previousDeployedResultProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceOrderDetails)) {
            return false;
        }
        ServiceOrderDetails other = (ServiceOrderDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$orderId = this.getOrderId();
        UUID other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !((Object)this$orderId).equals(other$orderId)) {
            return false;
        }
        UUID this$serviceId = this.getServiceId();
        UUID other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !((Object)this$serviceId).equals(other$serviceId)) {
            return false;
        }
        ServiceOrderType this$taskType = this.getTaskType();
        ServiceOrderType other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)((Object)this$taskType)).equals((Object)other$taskType)) {
            return false;
        }
        TaskStatus this$taskStatus = this.getTaskStatus();
        TaskStatus other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !((Object)((Object)this$taskStatus)).equals((Object)other$taskStatus)) {
            return false;
        }
        UUID this$originalServiceId = this.getOriginalServiceId();
        UUID other$originalServiceId = other.getOriginalServiceId();
        if (this$originalServiceId == null ? other$originalServiceId != null : !((Object)this$originalServiceId).equals(other$originalServiceId)) {
            return false;
        }
        UUID this$parentOrderId = this.getParentOrderId();
        UUID other$parentOrderId = other.getParentOrderId();
        if (this$parentOrderId == null ? other$parentOrderId != null : !((Object)this$parentOrderId).equals(other$parentOrderId)) {
            return false;
        }
        String this$workflowId = this.getWorkflowId();
        String other$workflowId = other.getWorkflowId();
        if (this$workflowId == null ? other$workflowId != null : !this$workflowId.equals(other$workflowId)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        OffsetDateTime this$startedTime = this.getStartedTime();
        OffsetDateTime other$startedTime = other.getStartedTime();
        if (this$startedTime == null ? other$startedTime != null : !((Object)this$startedTime).equals(other$startedTime)) {
            return false;
        }
        OffsetDateTime this$completedTime = this.getCompletedTime();
        OffsetDateTime other$completedTime = other.getCompletedTime();
        if (this$completedTime == null ? other$completedTime != null : !((Object)this$completedTime).equals(other$completedTime)) {
            return false;
        }
        Object this$requestBody = this.getRequestBody();
        Object other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        DeployRequest this$previousDeployRequest = this.getPreviousDeployRequest();
        DeployRequest other$previousDeployRequest = other.getPreviousDeployRequest();
        if (this$previousDeployRequest == null ? other$previousDeployRequest != null : !((Object)this$previousDeployRequest).equals(other$previousDeployRequest)) {
            return false;
        }
        DeployRequest this$newDeployRequest = this.getNewDeployRequest();
        DeployRequest other$newDeployRequest = other.getNewDeployRequest();
        if (this$newDeployRequest == null ? other$newDeployRequest != null : !((Object)this$newDeployRequest).equals(other$newDeployRequest)) {
            return false;
        }
        List<DeployResource> this$previousDeployedResources = this.getPreviousDeployedResources();
        List<DeployResource> other$previousDeployedResources = other.getPreviousDeployedResources();
        if (this$previousDeployedResources == null ? other$previousDeployedResources != null : !((Object)this$previousDeployedResources).equals(other$previousDeployedResources)) {
            return false;
        }
        Map<String, String> this$previousDeployedServiceProperties = this.getPreviousDeployedServiceProperties();
        Map<String, String> other$previousDeployedServiceProperties = other.getPreviousDeployedServiceProperties();
        if (this$previousDeployedServiceProperties == null ? other$previousDeployedServiceProperties != null : !((Object)this$previousDeployedServiceProperties).equals(other$previousDeployedServiceProperties)) {
            return false;
        }
        Map<String, String> this$previousDeployedResultProperties = this.getPreviousDeployedResultProperties();
        Map<String, String> other$previousDeployedResultProperties = other.getPreviousDeployedResultProperties();
        return !(this$previousDeployedResultProperties == null ? other$previousDeployedResultProperties != null : !((Object)this$previousDeployedResultProperties).equals(other$previousDeployedResultProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceOrderDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : ((Object)$orderId).hashCode());
        UUID $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : ((Object)$serviceId).hashCode());
        ServiceOrderType $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)((Object)$taskType)).hashCode());
        TaskStatus $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : ((Object)((Object)$taskStatus)).hashCode());
        UUID $originalServiceId = this.getOriginalServiceId();
        result = result * 59 + ($originalServiceId == null ? 43 : ((Object)$originalServiceId).hashCode());
        UUID $parentOrderId = this.getParentOrderId();
        result = result * 59 + ($parentOrderId == null ? 43 : ((Object)$parentOrderId).hashCode());
        String $workflowId = this.getWorkflowId();
        result = result * 59 + ($workflowId == null ? 43 : $workflowId.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        OffsetDateTime $startedTime = this.getStartedTime();
        result = result * 59 + ($startedTime == null ? 43 : ((Object)$startedTime).hashCode());
        OffsetDateTime $completedTime = this.getCompletedTime();
        result = result * 59 + ($completedTime == null ? 43 : ((Object)$completedTime).hashCode());
        Object $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        DeployRequest $previousDeployRequest = this.getPreviousDeployRequest();
        result = result * 59 + ($previousDeployRequest == null ? 43 : ((Object)$previousDeployRequest).hashCode());
        DeployRequest $newDeployRequest = this.getNewDeployRequest();
        result = result * 59 + ($newDeployRequest == null ? 43 : ((Object)$newDeployRequest).hashCode());
        List<DeployResource> $previousDeployedResources = this.getPreviousDeployedResources();
        result = result * 59 + ($previousDeployedResources == null ? 43 : ((Object)$previousDeployedResources).hashCode());
        Map<String, String> $previousDeployedServiceProperties = this.getPreviousDeployedServiceProperties();
        result = result * 59 + ($previousDeployedServiceProperties == null ? 43 : ((Object)$previousDeployedServiceProperties).hashCode());
        Map<String, String> $previousDeployedResultProperties = this.getPreviousDeployedResultProperties();
        result = result * 59 + ($previousDeployedResultProperties == null ? 43 : ((Object)$previousDeployedResultProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServiceOrderDetails(orderId=" + String.valueOf(this.getOrderId()) + ", serviceId=" + String.valueOf(this.getServiceId()) + ", taskType=" + String.valueOf((Object)this.getTaskType()) + ", taskStatus=" + String.valueOf((Object)this.getTaskStatus()) + ", originalServiceId=" + String.valueOf(this.getOriginalServiceId()) + ", parentOrderId=" + String.valueOf(this.getParentOrderId()) + ", workflowId=" + this.getWorkflowId() + ", errorMsg=" + this.getErrorMsg() + ", userId=" + this.getUserId() + ", startedTime=" + String.valueOf(this.getStartedTime()) + ", completedTime=" + String.valueOf(this.getCompletedTime()) + ", requestBody=" + String.valueOf(this.getRequestBody()) + ", previousDeployRequest=" + String.valueOf(this.getPreviousDeployRequest()) + ", newDeployRequest=" + String.valueOf(this.getNewDeployRequest()) + ", previousDeployedResources=" + String.valueOf(this.getPreviousDeployedResources()) + ", previousDeployedServiceProperties=" + String.valueOf(this.getPreviousDeployedServiceProperties()) + ", previousDeployedResultProperties=" + String.valueOf(this.getPreviousDeployedResultProperties()) + ")";
    }
}

