/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.order.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum ServiceOrderType {
    DEPLOY("deploy"),
    RETRY("retry"),
    ROLLBACK("rollback"),
    MODIFY("modify"),
    DESTROY("destroy"),
    MIGRATE("migrate"),
    RECREATE("recreate"),
    LOCK_CHANGE("lockChange"),
    CONFIG_CHANGE("configChange"),
    PURGE("purge"),
    SERVICE_START("serviceStart"),
    SERVICE_STOP("serviceStop"),
    SERVICE_RESTART("serviceRestart");

    private final String type;

    private ServiceOrderType(String type) {
        this.type = type;
    }

    @JsonCreator
    public static ServiceOrderType getByValue(String type) {
        for (ServiceOrderType item : ServiceOrderType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)item.type)) continue;
            return item;
        }
        throw new UnsupportedEnumValueException(String.format("ServiceOrderType type %s is not supported.", type));
    }

    @JsonValue
    public String toValue() {
        return this.type;
    }
}

