/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.statemanagement.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum ServiceState {
    NOT_RUNNING("not running"),
    RUNNING("running"),
    STARTING("starting"),
    STOPPING("stopping"),
    STOPPED("stopped"),
    RESTARTING("restarting");

    private final String value;

    private ServiceState(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ServiceState getByValue(String value) {
        for (ServiceState entry : ServiceState.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entry.value, (CharSequence)value)) continue;
            return entry;
        }
        throw new UnsupportedEnumValueException(String.format("ServiceState value %s is not supported.", value));
    }

    @JsonValue
    public String toValue() {
        return this.value;
    }
}

