/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.utils;

import com.networknt.schema.JsonMetaSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.servicetemplate.ServiceConfigurationParameter;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.DeployVariableKind;
import org.eclipse.xpanse.modules.models.servicetemplate.exceptions.InvalidValueSchemaException;
import org.eclipse.xpanse.modules.models.servicetemplate.utils.JsonObjectSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ServiceConfigurationVariablesJsonSchemaGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceConfigurationVariablesJsonSchemaGenerator.class);
    private static final String VARIABLE_TYPE_KEY = "type";
    private static final String VARIABLE_DESCRIPTION_KEY = "description";
    private static final String VARIABLE_EXAMPLE_KEY = "examples";

    public JsonObjectSchema buildServiceConfigurationJsonSchema(List<ServiceConfigurationParameter> serviceConfigurationParameters) {
        JsonObjectSchema jsonObjectSchema = new JsonObjectSchema();
        HashMap<String, Map<String, Object>> serviceConfigurationJsonSchemaProperties = new HashMap<String, Map<String, Object>>();
        for (ServiceConfigurationParameter configurationParameter : serviceConfigurationParameters) {
            if (configurationParameter.getKind() != DeployVariableKind.VARIABLE && configurationParameter.getKind() != DeployVariableKind.ENV) continue;
            HashMap<String, Object> validationProperties = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(configurationParameter.getValueSchema())) {
                validationProperties.putAll(configurationParameter.getValueSchema());
            }
            if (Objects.nonNull((Object)configurationParameter.getDataType())) {
                validationProperties.put(VARIABLE_TYPE_KEY, configurationParameter.getDataType().toValue());
            }
            if (Objects.nonNull(configurationParameter.getDescription())) {
                validationProperties.put(VARIABLE_DESCRIPTION_KEY, configurationParameter.getDescription());
            }
            if (Objects.nonNull(configurationParameter.getExample())) {
                validationProperties.put(VARIABLE_EXAMPLE_KEY, configurationParameter.getExample());
            }
            if (validationProperties.isEmpty()) continue;
            serviceConfigurationJsonSchemaProperties.put(configurationParameter.getName(), validationProperties);
        }
        jsonObjectSchema.setProperties(serviceConfigurationJsonSchemaProperties);
        this.validateSchemaDefinition(jsonObjectSchema);
        return jsonObjectSchema;
    }

    private void validateSchemaDefinition(JsonObjectSchema jsonObjectSchema) {
        Set allowedKeys = JsonMetaSchema.getV202012().getKeywords().keySet();
        ArrayList<String> invalidKeys = new ArrayList<String>();
        jsonObjectSchema.getProperties().forEach((deployVariable, variableValueSchema) -> variableValueSchema.forEach((schemaDefKey, schemaDefValue) -> {
            if (!allowedKeys.contains(schemaDefKey)) {
                invalidKeys.add(String.format("Value schema key %s in deploy variable %s is invalid", schemaDefKey, deployVariable));
            }
        }));
        if (!invalidKeys.isEmpty()) {
            throw new InvalidValueSchemaException(invalidKeys);
        }
    }
}

