/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.serviceconfiguration.exceptions.ServiceConfigurationInvalidException;
import org.eclipse.xpanse.modules.models.servicetemplate.ServiceConfigurationParameter;
import org.eclipse.xpanse.modules.models.servicetemplate.utils.JsonObjectSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ServiceConfigurationVariablesJsonSchemaValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceConfigurationVariablesJsonSchemaValidator.class);
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public void validateServiceConfiguration(List<ServiceConfigurationParameter> configurationParameters, Map<String, Object> configurations, JsonObjectSchema jsonObjectSchema) {
        if (CollectionUtils.isEmpty(configurationParameters) || Objects.isNull(jsonObjectSchema)) {
            return;
        }
        try {
            String jsonObjectSchemaString = this.jsonMapper.writeValueAsString((Object)jsonObjectSchema);
            Locale.setDefault(Locale.ENGLISH);
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
            JsonSchema schema = factory.getSchema(jsonObjectSchemaString);
            String propertyJson = this.jsonMapper.writeValueAsString(configurations);
            JsonNode jsonNode = this.jsonMapper.readTree(propertyJson);
            Set validate = schema.validate(jsonNode);
            if (!validate.isEmpty()) {
                ArrayList<String> errors = new ArrayList<String>();
                for (ValidationMessage validationMessage : validate) {
                    errors.add(validationMessage.getMessage().substring(3));
                }
                throw new ServiceConfigurationInvalidException(errors);
            }
        }
        catch (JsonProcessingException e) {
            ArrayList<String> errors = new ArrayList<String>();
            errors.add(e.getMessage());
            throw new ServiceConfigurationInvalidException(errors);
        }
    }
}

