/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.utils;

import com.networknt.schema.JsonMetaSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.servicetemplate.DeployVariable;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.DeployVariableKind;
import org.eclipse.xpanse.modules.models.servicetemplate.exceptions.InvalidValueSchemaException;
import org.eclipse.xpanse.modules.models.servicetemplate.utils.JsonObjectSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ServiceDeployVariablesJsonSchemaGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceDeployVariablesJsonSchemaGenerator.class);
    private static final String VARIABLE_TYPE_KEY = "type";
    private static final String VARIABLE_DESCRIPTION_KEY = "description";
    private static final String VARIABLE_EXAMPLE_KEY = "examples";

    public JsonObjectSchema buildDeployVariableJsonSchema(List<DeployVariable> deployVariables) {
        JsonObjectSchema jsonObjectSchema = new JsonObjectSchema();
        HashMap<String, Map<String, Object>> deployVariableJsonSchemaProperties = new HashMap<String, Map<String, Object>>();
        ArrayList<String> requiredList = new ArrayList<String>();
        for (DeployVariable variable : deployVariables) {
            if (variable.getKind() != DeployVariableKind.VARIABLE && variable.getKind() != DeployVariableKind.ENV) continue;
            HashMap<String, Object> validationProperties = new HashMap<String, Object>();
            if (Boolean.TRUE.equals(variable.getMandatory())) {
                requiredList.add(variable.getName());
            }
            if (!CollectionUtils.isEmpty(variable.getValueSchema())) {
                validationProperties.putAll(variable.getValueSchema());
            }
            if (Objects.nonNull((Object)variable.getDataType())) {
                validationProperties.put(VARIABLE_TYPE_KEY, variable.getDataType().toValue());
            }
            if (Objects.nonNull(variable.getDescription())) {
                validationProperties.put(VARIABLE_DESCRIPTION_KEY, variable.getDescription());
            }
            if (Objects.nonNull(variable.getExample())) {
                validationProperties.put(VARIABLE_EXAMPLE_KEY, variable.getExample());
            }
            if (validationProperties.isEmpty()) continue;
            deployVariableJsonSchemaProperties.put(variable.getName(), validationProperties);
        }
        jsonObjectSchema.setRequired(requiredList);
        jsonObjectSchema.setProperties(deployVariableJsonSchemaProperties);
        this.validateSchemaDefinition(jsonObjectSchema);
        return jsonObjectSchema;
    }

    private void validateSchemaDefinition(JsonObjectSchema jsonObjectSchema) {
        Set allowedKeys = JsonMetaSchema.getV202012().getKeywords().keySet();
        ArrayList<String> invalidKeys = new ArrayList<String>();
        jsonObjectSchema.getProperties().forEach((deployVariable, variableValueSchema) -> variableValueSchema.forEach((schemaDefKey, schemaDefValue) -> {
            if (!allowedKeys.contains(schemaDefKey)) {
                invalidKeys.add(String.format("Value schema key %s in deploy variable %s is invalid", schemaDefKey, deployVariable));
            }
        }));
        if (!invalidKeys.isEmpty()) {
            throw new InvalidValueSchemaException(invalidKeys);
        }
    }
}

