/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.service.deploy.exceptions.VariableValidationFailedException;
import org.eclipse.xpanse.modules.models.servicetemplate.DeployVariable;
import org.eclipse.xpanse.modules.models.servicetemplate.utils.JsonObjectSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ServiceDeployVariablesJsonSchemaValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceDeployVariablesJsonSchemaValidator.class);
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public void validateDeployVariables(List<DeployVariable> deployVariables, Map<String, Object> deployProperty, JsonObjectSchema jsonObjectSchema) {
        if (CollectionUtils.isEmpty(deployVariables) || Objects.isNull(jsonObjectSchema)) {
            return;
        }
        try {
            String jsonObjectSchemaString = this.jsonMapper.writeValueAsString((Object)jsonObjectSchema);
            Locale.setDefault(Locale.ENGLISH);
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
            JsonSchema schema = factory.getSchema(jsonObjectSchemaString);
            String propertyJson = this.jsonMapper.writeValueAsString(deployProperty);
            JsonNode jsonNode = this.jsonMapper.readTree(propertyJson);
            Set validate = schema.validate(jsonNode);
            if (!validate.isEmpty()) {
                ArrayList<String> errors = new ArrayList<String>();
                for (ValidationMessage validationMessage : validate) {
                    errors.add(validationMessage.getMessage().substring(3));
                }
                throw new VariableValidationFailedException(errors);
            }
        }
        catch (JsonProcessingException e) {
            ArrayList<String> errors = new ArrayList<String>();
            errors.add(e.getMessage());
            throw new VariableValidationFailedException(errors);
        }
    }
}

