/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.service.view;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.OffsetDateTime;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.billing.enums.BillingMode;
import org.eclipse.xpanse.modules.models.common.enums.Category;
import org.eclipse.xpanse.modules.models.common.enums.Csp;
import org.eclipse.xpanse.modules.models.service.config.ServiceLockConfig;
import org.eclipse.xpanse.modules.models.service.enums.ServiceDeploymentState;
import org.eclipse.xpanse.modules.models.service.statemanagement.enums.ServiceState;
import org.eclipse.xpanse.modules.models.servicetemplate.Region;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.ServiceHostingType;

public class DeployedService {
    @NotNull
    @Schema(description="The ID of the service")
    private UUID serviceId;
    @NotNull
    @Schema(description="The catalog of the service")
    private Category category;
    @NotNull
    @NotBlank
    @Schema(description="The name of the service")
    private String name;
    @Schema(description="Customer's name for the service. Used only for customer's reference.If not provided, this value will be auto-generated")
    private String customerServiceName;
    @NotNull
    @NotBlank
    @Schema(description="The version of the service")
    private String version;
    @NotNull
    @Schema(description="The provider of the service")
    private Csp csp;
    @Schema(description="The flavor of the service")
    private String flavor;
    @NotNull
    @Schema(description="The billing mode of the managed service.")
    private BillingMode billingMode;
    @NotNull
    @Schema(description="The region of the service.")
    private Region region;
    @Schema(description="The id of the Service Template")
    private UUID serviceTemplateId;
    @Schema(description="The id of the user who deployed the service.")
    private String userId;
    @NotNull
    @Schema(description="The deployment state of the service")
    private ServiceDeploymentState serviceDeploymentState;
    @NotNull
    @Schema(description="The run state of the service")
    private ServiceState serviceState = ServiceState.NOT_RUNNING;
    @NotNull
    @Schema(description="Defines which cloud service account is used for deploying cloud resources.")
    private ServiceHostingType serviceHostingType;
    @NotNull
    @Schema(description="Time of register service.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime createTime;
    @NotNull
    @Schema(description="Time of update service.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime lastModifiedTime;
    @Schema(description="Time of start service.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime lastStartedAt;
    @Schema(description="Time of stop service.")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    private OffsetDateTime lastStoppedAt;
    @Schema(description="The locks whether the service can be modified or destroyed.")
    private ServiceLockConfig lockConfig;

    @Generated
    public DeployedService() {
    }

    @Generated
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Generated
    public Category getCategory() {
        return this.category;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getCustomerServiceName() {
        return this.customerServiceName;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Csp getCsp() {
        return this.csp;
    }

    @Generated
    public String getFlavor() {
        return this.flavor;
    }

    @Generated
    public BillingMode getBillingMode() {
        return this.billingMode;
    }

    @Generated
    public Region getRegion() {
        return this.region;
    }

    @Generated
    public UUID getServiceTemplateId() {
        return this.serviceTemplateId;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public ServiceDeploymentState getServiceDeploymentState() {
        return this.serviceDeploymentState;
    }

    @Generated
    public ServiceState getServiceState() {
        return this.serviceState;
    }

    @Generated
    public ServiceHostingType getServiceHostingType() {
        return this.serviceHostingType;
    }

    @Generated
    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    @Generated
    public OffsetDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public OffsetDateTime getLastStartedAt() {
        return this.lastStartedAt;
    }

    @Generated
    public OffsetDateTime getLastStoppedAt() {
        return this.lastStoppedAt;
    }

    @Generated
    public ServiceLockConfig getLockConfig() {
        return this.lockConfig;
    }

    @Generated
    public void setServiceId(UUID serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public void setCategory(Category category) {
        this.category = category;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCustomerServiceName(String customerServiceName) {
        this.customerServiceName = customerServiceName;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setCsp(Csp csp) {
        this.csp = csp;
    }

    @Generated
    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    @Generated
    public void setBillingMode(BillingMode billingMode) {
        this.billingMode = billingMode;
    }

    @Generated
    public void setRegion(Region region) {
        this.region = region;
    }

    @Generated
    public void setServiceTemplateId(UUID serviceTemplateId) {
        this.serviceTemplateId = serviceTemplateId;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setServiceDeploymentState(ServiceDeploymentState serviceDeploymentState) {
        this.serviceDeploymentState = serviceDeploymentState;
    }

    @Generated
    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    @Generated
    public void setServiceHostingType(ServiceHostingType serviceHostingType) {
        this.serviceHostingType = serviceHostingType;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setLastStartedAt(OffsetDateTime lastStartedAt) {
        this.lastStartedAt = lastStartedAt;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss XXX")
    @Generated
    public void setLastStoppedAt(OffsetDateTime lastStoppedAt) {
        this.lastStoppedAt = lastStoppedAt;
    }

    @Generated
    public void setLockConfig(ServiceLockConfig lockConfig) {
        this.lockConfig = lockConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployedService)) {
            return false;
        }
        DeployedService other = (DeployedService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$serviceId = this.getServiceId();
        UUID other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !((Object)this$serviceId).equals(other$serviceId)) {
            return false;
        }
        Category this$category = this.getCategory();
        Category other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$customerServiceName = this.getCustomerServiceName();
        String other$customerServiceName = other.getCustomerServiceName();
        if (this$customerServiceName == null ? other$customerServiceName != null : !this$customerServiceName.equals(other$customerServiceName)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Csp this$csp = this.getCsp();
        Csp other$csp = other.getCsp();
        if (this$csp == null ? other$csp != null : !((Object)((Object)this$csp)).equals((Object)other$csp)) {
            return false;
        }
        String this$flavor = this.getFlavor();
        String other$flavor = other.getFlavor();
        if (this$flavor == null ? other$flavor != null : !this$flavor.equals(other$flavor)) {
            return false;
        }
        BillingMode this$billingMode = this.getBillingMode();
        BillingMode other$billingMode = other.getBillingMode();
        if (this$billingMode == null ? other$billingMode != null : !((Object)((Object)this$billingMode)).equals((Object)other$billingMode)) {
            return false;
        }
        Region this$region = this.getRegion();
        Region other$region = other.getRegion();
        if (this$region == null ? other$region != null : !((Object)this$region).equals(other$region)) {
            return false;
        }
        UUID this$serviceTemplateId = this.getServiceTemplateId();
        UUID other$serviceTemplateId = other.getServiceTemplateId();
        if (this$serviceTemplateId == null ? other$serviceTemplateId != null : !((Object)this$serviceTemplateId).equals(other$serviceTemplateId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        ServiceDeploymentState this$serviceDeploymentState = this.getServiceDeploymentState();
        ServiceDeploymentState other$serviceDeploymentState = other.getServiceDeploymentState();
        if (this$serviceDeploymentState == null ? other$serviceDeploymentState != null : !((Object)((Object)this$serviceDeploymentState)).equals((Object)other$serviceDeploymentState)) {
            return false;
        }
        ServiceState this$serviceState = this.getServiceState();
        ServiceState other$serviceState = other.getServiceState();
        if (this$serviceState == null ? other$serviceState != null : !((Object)((Object)this$serviceState)).equals((Object)other$serviceState)) {
            return false;
        }
        ServiceHostingType this$serviceHostingType = this.getServiceHostingType();
        ServiceHostingType other$serviceHostingType = other.getServiceHostingType();
        if (this$serviceHostingType == null ? other$serviceHostingType != null : !((Object)((Object)this$serviceHostingType)).equals((Object)other$serviceHostingType)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        OffsetDateTime this$lastModifiedTime = this.getLastModifiedTime();
        OffsetDateTime other$lastModifiedTime = other.getLastModifiedTime();
        if (this$lastModifiedTime == null ? other$lastModifiedTime != null : !((Object)this$lastModifiedTime).equals(other$lastModifiedTime)) {
            return false;
        }
        OffsetDateTime this$lastStartedAt = this.getLastStartedAt();
        OffsetDateTime other$lastStartedAt = other.getLastStartedAt();
        if (this$lastStartedAt == null ? other$lastStartedAt != null : !((Object)this$lastStartedAt).equals(other$lastStartedAt)) {
            return false;
        }
        OffsetDateTime this$lastStoppedAt = this.getLastStoppedAt();
        OffsetDateTime other$lastStoppedAt = other.getLastStoppedAt();
        if (this$lastStoppedAt == null ? other$lastStoppedAt != null : !((Object)this$lastStoppedAt).equals(other$lastStoppedAt)) {
            return false;
        }
        ServiceLockConfig this$lockConfig = this.getLockConfig();
        ServiceLockConfig other$lockConfig = other.getLockConfig();
        return !(this$lockConfig == null ? other$lockConfig != null : !((Object)this$lockConfig).equals(other$lockConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeployedService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : ((Object)$serviceId).hashCode());
        Category $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $customerServiceName = this.getCustomerServiceName();
        result = result * 59 + ($customerServiceName == null ? 43 : $customerServiceName.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Csp $csp = this.getCsp();
        result = result * 59 + ($csp == null ? 43 : ((Object)((Object)$csp)).hashCode());
        String $flavor = this.getFlavor();
        result = result * 59 + ($flavor == null ? 43 : $flavor.hashCode());
        BillingMode $billingMode = this.getBillingMode();
        result = result * 59 + ($billingMode == null ? 43 : ((Object)((Object)$billingMode)).hashCode());
        Region $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : ((Object)$region).hashCode());
        UUID $serviceTemplateId = this.getServiceTemplateId();
        result = result * 59 + ($serviceTemplateId == null ? 43 : ((Object)$serviceTemplateId).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        ServiceDeploymentState $serviceDeploymentState = this.getServiceDeploymentState();
        result = result * 59 + ($serviceDeploymentState == null ? 43 : ((Object)((Object)$serviceDeploymentState)).hashCode());
        ServiceState $serviceState = this.getServiceState();
        result = result * 59 + ($serviceState == null ? 43 : ((Object)((Object)$serviceState)).hashCode());
        ServiceHostingType $serviceHostingType = this.getServiceHostingType();
        result = result * 59 + ($serviceHostingType == null ? 43 : ((Object)((Object)$serviceHostingType)).hashCode());
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        OffsetDateTime $lastModifiedTime = this.getLastModifiedTime();
        result = result * 59 + ($lastModifiedTime == null ? 43 : ((Object)$lastModifiedTime).hashCode());
        OffsetDateTime $lastStartedAt = this.getLastStartedAt();
        result = result * 59 + ($lastStartedAt == null ? 43 : ((Object)$lastStartedAt).hashCode());
        OffsetDateTime $lastStoppedAt = this.getLastStoppedAt();
        result = result * 59 + ($lastStoppedAt == null ? 43 : ((Object)$lastStoppedAt).hashCode());
        ServiceLockConfig $lockConfig = this.getLockConfig();
        result = result * 59 + ($lockConfig == null ? 43 : ((Object)$lockConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeployedService(serviceId=" + String.valueOf(this.getServiceId()) + ", category=" + String.valueOf((Object)this.getCategory()) + ", name=" + this.getName() + ", customerServiceName=" + this.getCustomerServiceName() + ", version=" + this.getVersion() + ", csp=" + String.valueOf((Object)this.getCsp()) + ", flavor=" + this.getFlavor() + ", billingMode=" + String.valueOf((Object)this.getBillingMode()) + ", region=" + String.valueOf(this.getRegion()) + ", serviceTemplateId=" + String.valueOf(this.getServiceTemplateId()) + ", userId=" + this.getUserId() + ", serviceDeploymentState=" + String.valueOf((Object)this.getServiceDeploymentState()) + ", serviceState=" + String.valueOf((Object)this.getServiceState()) + ", serviceHostingType=" + String.valueOf((Object)this.getServiceHostingType()) + ", createTime=" + String.valueOf(this.getCreateTime()) + ", lastModifiedTime=" + String.valueOf(this.getLastModifiedTime()) + ", lastStartedAt=" + String.valueOf(this.getLastStartedAt()) + ", lastStoppedAt=" + String.valueOf(this.getLastStoppedAt()) + ", lockConfig=" + String.valueOf(this.getLockConfig()) + ")";
    }
}

