/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Valid
public class AnsibleScriptConfig
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnsibleScriptConfig.class);
    private static final long serialVersionUID = 1L;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="name of the ansible playbook. Should be the fully qualified file name (including the directory path) in the repo.", example="playbook-name.yml")
    private String playbookName;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="Path where the virtualenv must be created.", example="/tmp/virtualEnv")
    private String virtualEnv;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="Version of the python. This version of python must be available in node which is acting as the configManager.", example="3.10")
    private String pythonVersion;
    @NotNull
    @Schema(description="The agent will prepare the virtual environment if this true.Otherwise it is assumed that the environment is already prepared as part of the resource creation or the VM base image build.")
    private Boolean isPrepareAnsibleEnvironment;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="Url of the script repo.")
    private String repoUrl;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="Branch of the git repo.")
    private String branch;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="the python module requirements file in GIT repo. Should be the fully qualified file name (including the directory path). ", example="modules/requirements.txt")
    private String requirementsFile;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="Full path of the roles and collections requirements file in GIT repo.")
    private String galaxyFile;
    @Schema(description="Defines if the complete service inventory is necessary for running the ansible job.")
    private Boolean ansibleInventoryRequired;

    @Generated
    public AnsibleScriptConfig() {
    }

    @Generated
    public String getPlaybookName() {
        return this.playbookName;
    }

    @Generated
    public String getVirtualEnv() {
        return this.virtualEnv;
    }

    @Generated
    public String getPythonVersion() {
        return this.pythonVersion;
    }

    @Generated
    public Boolean getIsPrepareAnsibleEnvironment() {
        return this.isPrepareAnsibleEnvironment;
    }

    @Generated
    public String getRepoUrl() {
        return this.repoUrl;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public String getRequirementsFile() {
        return this.requirementsFile;
    }

    @Generated
    public String getGalaxyFile() {
        return this.galaxyFile;
    }

    @Generated
    public Boolean getAnsibleInventoryRequired() {
        return this.ansibleInventoryRequired;
    }

    @Generated
    public void setPlaybookName(String playbookName) {
        this.playbookName = playbookName;
    }

    @Generated
    public void setVirtualEnv(String virtualEnv) {
        this.virtualEnv = virtualEnv;
    }

    @Generated
    public void setPythonVersion(String pythonVersion) {
        this.pythonVersion = pythonVersion;
    }

    @Generated
    public void setIsPrepareAnsibleEnvironment(Boolean isPrepareAnsibleEnvironment) {
        this.isPrepareAnsibleEnvironment = isPrepareAnsibleEnvironment;
    }

    @Generated
    public void setRepoUrl(String repoUrl) {
        this.repoUrl = repoUrl;
    }

    @Generated
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Generated
    public void setRequirementsFile(String requirementsFile) {
        this.requirementsFile = requirementsFile;
    }

    @Generated
    public void setGalaxyFile(String galaxyFile) {
        this.galaxyFile = galaxyFile;
    }

    @Generated
    public void setAnsibleInventoryRequired(Boolean ansibleInventoryRequired) {
        this.ansibleInventoryRequired = ansibleInventoryRequired;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnsibleScriptConfig)) {
            return false;
        }
        AnsibleScriptConfig other = (AnsibleScriptConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isPrepareAnsibleEnvironment = this.getIsPrepareAnsibleEnvironment();
        Boolean other$isPrepareAnsibleEnvironment = other.getIsPrepareAnsibleEnvironment();
        if (this$isPrepareAnsibleEnvironment == null ? other$isPrepareAnsibleEnvironment != null : !((Object)this$isPrepareAnsibleEnvironment).equals(other$isPrepareAnsibleEnvironment)) {
            return false;
        }
        Boolean this$ansibleInventoryRequired = this.getAnsibleInventoryRequired();
        Boolean other$ansibleInventoryRequired = other.getAnsibleInventoryRequired();
        if (this$ansibleInventoryRequired == null ? other$ansibleInventoryRequired != null : !((Object)this$ansibleInventoryRequired).equals(other$ansibleInventoryRequired)) {
            return false;
        }
        String this$playbookName = this.getPlaybookName();
        String other$playbookName = other.getPlaybookName();
        if (this$playbookName == null ? other$playbookName != null : !this$playbookName.equals(other$playbookName)) {
            return false;
        }
        String this$virtualEnv = this.getVirtualEnv();
        String other$virtualEnv = other.getVirtualEnv();
        if (this$virtualEnv == null ? other$virtualEnv != null : !this$virtualEnv.equals(other$virtualEnv)) {
            return false;
        }
        String this$pythonVersion = this.getPythonVersion();
        String other$pythonVersion = other.getPythonVersion();
        if (this$pythonVersion == null ? other$pythonVersion != null : !this$pythonVersion.equals(other$pythonVersion)) {
            return false;
        }
        String this$repoUrl = this.getRepoUrl();
        String other$repoUrl = other.getRepoUrl();
        if (this$repoUrl == null ? other$repoUrl != null : !this$repoUrl.equals(other$repoUrl)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$requirementsFile = this.getRequirementsFile();
        String other$requirementsFile = other.getRequirementsFile();
        if (this$requirementsFile == null ? other$requirementsFile != null : !this$requirementsFile.equals(other$requirementsFile)) {
            return false;
        }
        String this$galaxyFile = this.getGalaxyFile();
        String other$galaxyFile = other.getGalaxyFile();
        return !(this$galaxyFile == null ? other$galaxyFile != null : !this$galaxyFile.equals(other$galaxyFile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnsibleScriptConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isPrepareAnsibleEnvironment = this.getIsPrepareAnsibleEnvironment();
        result = result * 59 + ($isPrepareAnsibleEnvironment == null ? 43 : ((Object)$isPrepareAnsibleEnvironment).hashCode());
        Boolean $ansibleInventoryRequired = this.getAnsibleInventoryRequired();
        result = result * 59 + ($ansibleInventoryRequired == null ? 43 : ((Object)$ansibleInventoryRequired).hashCode());
        String $playbookName = this.getPlaybookName();
        result = result * 59 + ($playbookName == null ? 43 : $playbookName.hashCode());
        String $virtualEnv = this.getVirtualEnv();
        result = result * 59 + ($virtualEnv == null ? 43 : $virtualEnv.hashCode());
        String $pythonVersion = this.getPythonVersion();
        result = result * 59 + ($pythonVersion == null ? 43 : $pythonVersion.hashCode());
        String $repoUrl = this.getRepoUrl();
        result = result * 59 + ($repoUrl == null ? 43 : $repoUrl.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $requirementsFile = this.getRequirementsFile();
        result = result * 59 + ($requirementsFile == null ? 43 : $requirementsFile.hashCode());
        String $galaxyFile = this.getGalaxyFile();
        result = result * 59 + ($galaxyFile == null ? 43 : $galaxyFile.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnsibleScriptConfig(playbookName=" + this.getPlaybookName() + ", virtualEnv=" + this.getVirtualEnv() + ", pythonVersion=" + this.getPythonVersion() + ", isPrepareAnsibleEnvironment=" + this.getIsPrepareAnsibleEnvironment() + ", repoUrl=" + this.getRepoUrl() + ", branch=" + this.getBranch() + ", requirementsFile=" + this.getRequirementsFile() + ", galaxyFile=" + this.getGalaxyFile() + ", ansibleInventoryRequired=" + this.getAnsibleInventoryRequired() + ")";
    }
}

