/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.servicetemplate.AutoFill;
import org.eclipse.xpanse.modules.models.servicetemplate.ModificationImpact;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.DeployVariableDataType;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.DeployVariableKind;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.SensitiveScope;

public class DeployVariable
implements Serializable {
    private static final long serialVersionUID = 4180720936204332115L;
    @NotNull
    @NotBlank
    @Schema(description="The name of the deploy variable")
    private String name;
    @NotNull
    @Schema(description="The kind of the deploy variable")
    private DeployVariableKind kind;
    @NotNull
    @Schema(description="The type of the deploy variable")
    private DeployVariableDataType dataType;
    @Schema(description="The example value of the deploy variable")
    private String example;
    @NotNull
    @NotBlank
    @Schema(description="The description of the deploy variable")
    private String description;
    @Schema(description="The value of the deploy variable. Value can be provided for default variables")
    private String value;
    @NotNull
    @Schema(description="Indicates if the variable is mandatory")
    private Boolean mandatory;
    @Schema(description="valueSchema of the variable. The key be any keyword that is part of the JSON schema definition which can be found here https://json-schema.org/draft/2020-12/schema")
    private Map<String, Object> valueSchema;
    @Schema(description="Sensitive scope of variable storage")
    private SensitiveScope sensitiveScope = SensitiveScope.NONE;
    @Schema(description="Variable autofill")
    private AutoFill autoFill;
    @NotNull
    @Schema(description="Variable modificationImpact")
    private ModificationImpact modificationImpact;

    @Generated
    public DeployVariable() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DeployVariableKind getKind() {
        return this.kind;
    }

    @Generated
    public DeployVariableDataType getDataType() {
        return this.dataType;
    }

    @Generated
    public String getExample() {
        return this.example;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Boolean getMandatory() {
        return this.mandatory;
    }

    @Generated
    public Map<String, Object> getValueSchema() {
        return this.valueSchema;
    }

    @Generated
    public SensitiveScope getSensitiveScope() {
        return this.sensitiveScope;
    }

    @Generated
    public AutoFill getAutoFill() {
        return this.autoFill;
    }

    @Generated
    public ModificationImpact getModificationImpact() {
        return this.modificationImpact;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setKind(DeployVariableKind kind) {
        this.kind = kind;
    }

    @Generated
    public void setDataType(DeployVariableDataType dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setExample(String example) {
        this.example = example;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Generated
    public void setValueSchema(Map<String, Object> valueSchema) {
        this.valueSchema = valueSchema;
    }

    @Generated
    public void setSensitiveScope(SensitiveScope sensitiveScope) {
        this.sensitiveScope = sensitiveScope;
    }

    @Generated
    public void setAutoFill(AutoFill autoFill) {
        this.autoFill = autoFill;
    }

    @Generated
    public void setModificationImpact(ModificationImpact modificationImpact) {
        this.modificationImpact = modificationImpact;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployVariable)) {
            return false;
        }
        DeployVariable other = (DeployVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$mandatory = this.getMandatory();
        Boolean other$mandatory = other.getMandatory();
        if (this$mandatory == null ? other$mandatory != null : !((Object)this$mandatory).equals(other$mandatory)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DeployVariableKind this$kind = this.getKind();
        DeployVariableKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        DeployVariableDataType this$dataType = this.getDataType();
        DeployVariableDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$example = this.getExample();
        String other$example = other.getExample();
        if (this$example == null ? other$example != null : !this$example.equals(other$example)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Map<String, Object> this$valueSchema = this.getValueSchema();
        Map<String, Object> other$valueSchema = other.getValueSchema();
        if (this$valueSchema == null ? other$valueSchema != null : !((Object)this$valueSchema).equals(other$valueSchema)) {
            return false;
        }
        SensitiveScope this$sensitiveScope = this.getSensitiveScope();
        SensitiveScope other$sensitiveScope = other.getSensitiveScope();
        if (this$sensitiveScope == null ? other$sensitiveScope != null : !((Object)((Object)this$sensitiveScope)).equals((Object)other$sensitiveScope)) {
            return false;
        }
        AutoFill this$autoFill = this.getAutoFill();
        AutoFill other$autoFill = other.getAutoFill();
        if (this$autoFill == null ? other$autoFill != null : !((Object)this$autoFill).equals(other$autoFill)) {
            return false;
        }
        ModificationImpact this$modificationImpact = this.getModificationImpact();
        ModificationImpact other$modificationImpact = other.getModificationImpact();
        return !(this$modificationImpact == null ? other$modificationImpact != null : !((Object)this$modificationImpact).equals(other$modificationImpact));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeployVariable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $mandatory = this.getMandatory();
        result = result * 59 + ($mandatory == null ? 43 : ((Object)$mandatory).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DeployVariableKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        DeployVariableDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $example = this.getExample();
        result = result * 59 + ($example == null ? 43 : $example.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Map<String, Object> $valueSchema = this.getValueSchema();
        result = result * 59 + ($valueSchema == null ? 43 : ((Object)$valueSchema).hashCode());
        SensitiveScope $sensitiveScope = this.getSensitiveScope();
        result = result * 59 + ($sensitiveScope == null ? 43 : ((Object)((Object)$sensitiveScope)).hashCode());
        AutoFill $autoFill = this.getAutoFill();
        result = result * 59 + ($autoFill == null ? 43 : ((Object)$autoFill).hashCode());
        ModificationImpact $modificationImpact = this.getModificationImpact();
        result = result * 59 + ($modificationImpact == null ? 43 : ((Object)$modificationImpact).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeployVariable(name=" + this.getName() + ", kind=" + String.valueOf((Object)this.getKind()) + ", dataType=" + String.valueOf((Object)this.getDataType()) + ", example=" + this.getExample() + ", description=" + this.getDescription() + ", value=" + this.getValue() + ", mandatory=" + this.getMandatory() + ", valueSchema=" + String.valueOf(this.getValueSchema()) + ", sensitiveScope=" + String.valueOf((Object)this.getSensitiveScope()) + ", autoFill=" + String.valueOf(this.getAutoFill()) + ", modificationImpact=" + String.valueOf(this.getModificationImpact()) + ")";
    }
}

