/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.DeployerKind;
import org.springframework.validation.annotation.Validated;

@Validated
public class DeployerTool {
    @Hidden
    public static final String DEPLOYER_TOOL_REQUIRED_VERSION_REGEX = "^(=|>=|<=)\\s*[vV]?\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$";
    @NotNull
    @Schema(description="The type of the deployer which will handle the service deployment.")
    private DeployerKind kind;
    @NotNull
    @NotBlank
    @Pattern(regexp="^(=|>=|<=)\\s*[vV]?\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$")
    @Schema(description="The version of the deployer which will handle the service deployment.")
    private @NotNull @NotBlank @Pattern(regexp="^(=|>=|<=)\\s*[vV]?\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$") String version;

    @Generated
    public DeployerTool() {
    }

    @Generated
    public DeployerKind getKind() {
        return this.kind;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setKind(DeployerKind kind) {
        this.kind = kind;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployerTool)) {
            return false;
        }
        DeployerTool other = (DeployerTool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeployerKind this$kind = this.getKind();
        DeployerKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeployerTool;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeployerKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeployerTool(kind=" + String.valueOf((Object)this.getKind()) + ", version=" + this.getVersion() + ")";
    }
}

