/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.credential.enums.CredentialType;
import org.eclipse.xpanse.modules.models.servicetemplate.AvailabilityZoneConfig;
import org.eclipse.xpanse.modules.models.servicetemplate.DeployVariable;
import org.eclipse.xpanse.modules.models.servicetemplate.DeployerTool;
import org.eclipse.xpanse.modules.models.servicetemplate.ScriptsRepo;
import org.hibernate.validator.constraints.UniqueElements;
import org.springframework.validation.annotation.Validated;

@Validated
public class Deployment
implements Serializable {
    private static final long serialVersionUID = 2566478948717883360L;
    @Valid
    @NotNull
    @Schema(description="The deployer tool which will handle the service deployment.")
    private DeployerTool deployerTool;
    @Valid
    @NotNull
    @NotEmpty
    @UniqueElements
    @Schema(description="The variables for the deployment, which will be passed to the deployer.The list elements must be unique.")
    private List<DeployVariable> variables;
    @Schema(description="The credential type to do the deployment")
    private CredentialType credentialType = CredentialType.VARIABLES;
    @Valid
    @Size(min=1)
    @UniqueElements
    @Schema(description="The list of availability zone configuration of the service.The list elements must be unique.")
    private @Valid @Size(min=1) @UniqueElements List<AvailabilityZoneConfig> serviceAvailabilityConfig;
    @Schema(description="The real deployer, something like terraform scripts. Either deployer or deployFromGitRepo must be provided.")
    private String deployer;
    @Schema(description="Deployment scripts hosted on a GIT repo. Either deployer or deployFromGitRepo must be provided.")
    private ScriptsRepo scriptsRepo;

    @Generated
    public Deployment() {
    }

    @Generated
    public DeployerTool getDeployerTool() {
        return this.deployerTool;
    }

    @Generated
    public List<DeployVariable> getVariables() {
        return this.variables;
    }

    @Generated
    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    @Generated
    public List<AvailabilityZoneConfig> getServiceAvailabilityConfig() {
        return this.serviceAvailabilityConfig;
    }

    @Generated
    public String getDeployer() {
        return this.deployer;
    }

    @Generated
    public ScriptsRepo getScriptsRepo() {
        return this.scriptsRepo;
    }

    @Generated
    public void setDeployerTool(DeployerTool deployerTool) {
        this.deployerTool = deployerTool;
    }

    @Generated
    public void setVariables(List<DeployVariable> variables) {
        this.variables = variables;
    }

    @Generated
    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    @Generated
    public void setServiceAvailabilityConfig(List<AvailabilityZoneConfig> serviceAvailabilityConfig) {
        this.serviceAvailabilityConfig = serviceAvailabilityConfig;
    }

    @Generated
    public void setDeployer(String deployer) {
        this.deployer = deployer;
    }

    @Generated
    public void setScriptsRepo(ScriptsRepo scriptsRepo) {
        this.scriptsRepo = scriptsRepo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeployerTool this$deployerTool = this.getDeployerTool();
        DeployerTool other$deployerTool = other.getDeployerTool();
        if (this$deployerTool == null ? other$deployerTool != null : !((Object)this$deployerTool).equals(other$deployerTool)) {
            return false;
        }
        List<DeployVariable> this$variables = this.getVariables();
        List<DeployVariable> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        CredentialType this$credentialType = this.getCredentialType();
        CredentialType other$credentialType = other.getCredentialType();
        if (this$credentialType == null ? other$credentialType != null : !((Object)((Object)this$credentialType)).equals((Object)other$credentialType)) {
            return false;
        }
        List<AvailabilityZoneConfig> this$serviceAvailabilityConfig = this.getServiceAvailabilityConfig();
        List<AvailabilityZoneConfig> other$serviceAvailabilityConfig = other.getServiceAvailabilityConfig();
        if (this$serviceAvailabilityConfig == null ? other$serviceAvailabilityConfig != null : !((Object)this$serviceAvailabilityConfig).equals(other$serviceAvailabilityConfig)) {
            return false;
        }
        String this$deployer = this.getDeployer();
        String other$deployer = other.getDeployer();
        if (this$deployer == null ? other$deployer != null : !this$deployer.equals(other$deployer)) {
            return false;
        }
        ScriptsRepo this$scriptsRepo = this.getScriptsRepo();
        ScriptsRepo other$scriptsRepo = other.getScriptsRepo();
        return !(this$scriptsRepo == null ? other$scriptsRepo != null : !((Object)this$scriptsRepo).equals(other$scriptsRepo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Deployment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeployerTool $deployerTool = this.getDeployerTool();
        result = result * 59 + ($deployerTool == null ? 43 : ((Object)$deployerTool).hashCode());
        List<DeployVariable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        CredentialType $credentialType = this.getCredentialType();
        result = result * 59 + ($credentialType == null ? 43 : ((Object)((Object)$credentialType)).hashCode());
        List<AvailabilityZoneConfig> $serviceAvailabilityConfig = this.getServiceAvailabilityConfig();
        result = result * 59 + ($serviceAvailabilityConfig == null ? 43 : ((Object)$serviceAvailabilityConfig).hashCode());
        String $deployer = this.getDeployer();
        result = result * 59 + ($deployer == null ? 43 : $deployer.hashCode());
        ScriptsRepo $scriptsRepo = this.getScriptsRepo();
        result = result * 59 + ($scriptsRepo == null ? 43 : ((Object)$scriptsRepo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Deployment(deployerTool=" + String.valueOf(this.getDeployerTool()) + ", variables=" + String.valueOf(this.getVariables()) + ", credentialType=" + String.valueOf((Object)this.getCredentialType()) + ", serviceAvailabilityConfig=" + String.valueOf(this.getServiceAvailabilityConfig()) + ", deployer=" + this.getDeployer() + ", scriptsRepo=" + String.valueOf(this.getScriptsRepo()) + ")";
    }
}

