/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.eclipse.xpanse.modules.models.servicetemplate.AutoFill;
import org.eclipse.xpanse.modules.models.servicetemplate.ModificationImpact;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.DeployVariableDataType;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.DeployVariableKind;
import org.eclipse.xpanse.modules.models.servicetemplate.enums.SensitiveScope;

public class ServiceConfigurationParameter
implements Serializable {
    private static final long serialVersionUID = 4180720936204332216L;
    @NotNull
    @NotBlank
    @Schema(description="The name of the service config parameter")
    private String name;
    @NotNull
    @Schema(description="The kind of the service config parameter")
    private DeployVariableKind kind;
    @NotNull
    @Schema(description="The type of the service config parameter")
    private DeployVariableDataType dataType;
    @Schema(description="The example value of the service config parameter")
    private String example;
    @NotNull
    @NotBlank
    @Schema(description="The description of the service config parameter")
    private String description;
    @Schema(description="The value of the service config parameter. Value can be provided for initial value")
    private String value;
    @NotNull
    @Schema(description="The init value of the service config parameter")
    private String initialValue;
    @Schema(description="valueSchema of the service config parameter. The key be any keyword that is part of the JSON schema definition which can be found here https://json-schema.org/draft/2020-12/schema")
    private Map<String, Object> valueSchema;
    @Schema(description="Sensitive scope of service config parameter storage")
    private SensitiveScope sensitiveScope = SensitiveScope.NONE;
    @Schema(description="Service config parameter autofill")
    private AutoFill autoFill;
    @NotNull
    @Schema(description="Service config parameter modificationImpact")
    private ModificationImpact modificationImpact;
    @NotNull
    @Schema(description="Whether the service configuration parameters are read-only")
    private Boolean isReadOnly;
    @NotNull
    @NotBlank
    @Schema(description="Service component which manages this configuration parameter.")
    private String managedBy;

    @Generated
    public ServiceConfigurationParameter() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DeployVariableKind getKind() {
        return this.kind;
    }

    @Generated
    public DeployVariableDataType getDataType() {
        return this.dataType;
    }

    @Generated
    public String getExample() {
        return this.example;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getInitialValue() {
        return this.initialValue;
    }

    @Generated
    public Map<String, Object> getValueSchema() {
        return this.valueSchema;
    }

    @Generated
    public SensitiveScope getSensitiveScope() {
        return this.sensitiveScope;
    }

    @Generated
    public AutoFill getAutoFill() {
        return this.autoFill;
    }

    @Generated
    public ModificationImpact getModificationImpact() {
        return this.modificationImpact;
    }

    @Generated
    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    @Generated
    public String getManagedBy() {
        return this.managedBy;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setKind(DeployVariableKind kind) {
        this.kind = kind;
    }

    @Generated
    public void setDataType(DeployVariableDataType dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setExample(String example) {
        this.example = example;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    @Generated
    public void setValueSchema(Map<String, Object> valueSchema) {
        this.valueSchema = valueSchema;
    }

    @Generated
    public void setSensitiveScope(SensitiveScope sensitiveScope) {
        this.sensitiveScope = sensitiveScope;
    }

    @Generated
    public void setAutoFill(AutoFill autoFill) {
        this.autoFill = autoFill;
    }

    @Generated
    public void setModificationImpact(ModificationImpact modificationImpact) {
        this.modificationImpact = modificationImpact;
    }

    @Generated
    public void setIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Generated
    public void setManagedBy(String managedBy) {
        this.managedBy = managedBy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceConfigurationParameter)) {
            return false;
        }
        ServiceConfigurationParameter other = (ServiceConfigurationParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isReadOnly = this.getIsReadOnly();
        Boolean other$isReadOnly = other.getIsReadOnly();
        if (this$isReadOnly == null ? other$isReadOnly != null : !((Object)this$isReadOnly).equals(other$isReadOnly)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DeployVariableKind this$kind = this.getKind();
        DeployVariableKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        DeployVariableDataType this$dataType = this.getDataType();
        DeployVariableDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$example = this.getExample();
        String other$example = other.getExample();
        if (this$example == null ? other$example != null : !this$example.equals(other$example)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$initialValue = this.getInitialValue();
        String other$initialValue = other.getInitialValue();
        if (this$initialValue == null ? other$initialValue != null : !this$initialValue.equals(other$initialValue)) {
            return false;
        }
        Map<String, Object> this$valueSchema = this.getValueSchema();
        Map<String, Object> other$valueSchema = other.getValueSchema();
        if (this$valueSchema == null ? other$valueSchema != null : !((Object)this$valueSchema).equals(other$valueSchema)) {
            return false;
        }
        SensitiveScope this$sensitiveScope = this.getSensitiveScope();
        SensitiveScope other$sensitiveScope = other.getSensitiveScope();
        if (this$sensitiveScope == null ? other$sensitiveScope != null : !((Object)((Object)this$sensitiveScope)).equals((Object)other$sensitiveScope)) {
            return false;
        }
        AutoFill this$autoFill = this.getAutoFill();
        AutoFill other$autoFill = other.getAutoFill();
        if (this$autoFill == null ? other$autoFill != null : !((Object)this$autoFill).equals(other$autoFill)) {
            return false;
        }
        ModificationImpact this$modificationImpact = this.getModificationImpact();
        ModificationImpact other$modificationImpact = other.getModificationImpact();
        if (this$modificationImpact == null ? other$modificationImpact != null : !((Object)this$modificationImpact).equals(other$modificationImpact)) {
            return false;
        }
        String this$managedBy = this.getManagedBy();
        String other$managedBy = other.getManagedBy();
        return !(this$managedBy == null ? other$managedBy != null : !this$managedBy.equals(other$managedBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceConfigurationParameter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isReadOnly = this.getIsReadOnly();
        result = result * 59 + ($isReadOnly == null ? 43 : ((Object)$isReadOnly).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DeployVariableKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        DeployVariableDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $example = this.getExample();
        result = result * 59 + ($example == null ? 43 : $example.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $initialValue = this.getInitialValue();
        result = result * 59 + ($initialValue == null ? 43 : $initialValue.hashCode());
        Map<String, Object> $valueSchema = this.getValueSchema();
        result = result * 59 + ($valueSchema == null ? 43 : ((Object)$valueSchema).hashCode());
        SensitiveScope $sensitiveScope = this.getSensitiveScope();
        result = result * 59 + ($sensitiveScope == null ? 43 : ((Object)((Object)$sensitiveScope)).hashCode());
        AutoFill $autoFill = this.getAutoFill();
        result = result * 59 + ($autoFill == null ? 43 : ((Object)$autoFill).hashCode());
        ModificationImpact $modificationImpact = this.getModificationImpact();
        result = result * 59 + ($modificationImpact == null ? 43 : ((Object)$modificationImpact).hashCode());
        String $managedBy = this.getManagedBy();
        result = result * 59 + ($managedBy == null ? 43 : $managedBy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServiceConfigurationParameter(name=" + this.getName() + ", kind=" + String.valueOf((Object)this.getKind()) + ", dataType=" + String.valueOf((Object)this.getDataType()) + ", example=" + this.getExample() + ", description=" + this.getDescription() + ", value=" + this.getValue() + ", initialValue=" + this.getInitialValue() + ", valueSchema=" + String.valueOf(this.getValueSchema()) + ", sensitiveScope=" + String.valueOf((Object)this.getSensitiveScope()) + ", autoFill=" + String.valueOf(this.getAutoFill()) + ", modificationImpact=" + String.valueOf(this.getModificationImpact()) + ", isReadOnly=" + this.getIsReadOnly() + ", managedBy=" + this.getManagedBy() + ")";
    }
}

