/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ServiceFlavor
implements Serializable {
    private static final long serialVersionUID = 7178375302626204744L;
    @NotNull
    @NotBlank
    @NotEmpty
    @Schema(description="The flavor name")
    private String name;
    @NotNull
    @NotEmpty
    @Schema(description="The properties of the flavor")
    private Map<String, String> properties;
    @NotNull
    @Min(value=1L, message="The minimum value of priority cannot be less than 1.")
    @Schema(description="The priority of the flavor. The larger value means lower priority.")
    private @NotNull @Min(value=1L, message="The minimum value of priority cannot be less than 1.") Integer priority;
    @Schema(description="Important features and differentiators of the flavor.")
    List<String> features;

    @Generated
    public ServiceFlavor() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public List<String> getFeatures() {
        return this.features;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public void setFeatures(List<String> features) {
        this.features = features;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceFlavor)) {
            return false;
        }
        ServiceFlavor other = (ServiceFlavor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$priority = this.getPriority();
        Integer other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<String> this$features = this.getFeatures();
        List<String> other$features = other.getFeatures();
        return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceFlavor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<String> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServiceFlavor(name=" + this.getName() + ", properties=" + String.valueOf(this.getProperties()) + ", priority=" + this.getPriority() + ", features=" + String.valueOf(this.getFeatures()) + ")";
    }
}

