/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

@Schema(enumAsRef=true, description="- `fix_env`: Values for variable of this type are defined by the managed service provider \nin the OCL template. Runtime will inject it to deployer as environment variables. \nThis variable is not visible to the end user.\n- `fix_variable`: Values for variable of this type are defined by the managed service \nprovider in the OCL template. Runtime will inject it to deployer as usual variables. \nThis variable is not visible to the end user.\n- `env`: Value for a variable of this type can be provided by end user. \nIf marked as mandatory then end user must provide value to this variable. \nIf marked as optional and if end user does not provide it, \nthen the fallback value to this variable is read by runtime (it can read from other sources,\n e.g., OS env variables). This variable is injected as an environment \n variable to the deployer.\n- `variable`: Value for a variable of this type can be provided by end user. \nIf marked as mandatory then end user must provide value to this variable. \nIf marked as optional and if end user does not provide it, \nthen the fallback value to this variable is read by runtime (it can read from other sources,\n e.g., OS env variables). This variable is injected as a regular variable to the deployer.\n- `env_env`: Value to this variable is read by runtime \n(it can read from other sources, e.g., OS env variables) \nand injected as an environment variable to the deployer. \nEnd user cannot see or change this variable.\n- `env_variable`: Value to this variable is read by runtime \n(it can read from other sources, e.g., OS env variables) \nand injected as a regular variable to the deployer. \nEnd user cannot see or change this variable.")
public enum DeployVariableKind {
    FIX_ENV("fix_env"),
    FIX_VARIABLE("fix_variable"),
    ENV("env"),
    VARIABLE("variable"),
    ENV_ENV("env_env"),
    ENV_VARIABLE("env_variable");

    private final String type;

    private DeployVariableKind(String type) {
        this.type = type;
    }

    @JsonCreator
    public DeployVariableKind getByValue(String type) {
        for (DeployVariableKind deployVariableKind : DeployVariableKind.values()) {
            if (!deployVariableKind.type.equals(StringUtils.lowerCase((String)type))) continue;
            return deployVariableKind;
        }
        throw new UnsupportedEnumValueException(String.format("DeployVariableKind value %s is not supported.", type));
    }

    @JsonValue
    public String toValue() {
        return this.type;
    }
}

