/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum DeployerKind {
    TERRAFORM("terraform"),
    OPEN_TOFU("opentofu");

    private final String type;

    private DeployerKind(String type) {
        this.type = type;
    }

    @JsonCreator
    public static DeployerKind getByValue(String type) {
        for (DeployerKind kind : DeployerKind.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)kind.type, (CharSequence)type)) continue;
            return kind;
        }
        throw new UnsupportedEnumValueException(String.format("DeployerKind value %s is not supported.", type));
    }

    @JsonValue
    public String toValue() {
        return this.type;
    }
}

