/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.servicetemplate.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

@Schema(description="Defines which cloud service account is used for deploying cloud resources.")
public enum ServiceHostingType {
    SELF("self"),
    SERVICE_VENDOR("service-vendor");

    private final String serviceHostingType;

    private ServiceHostingType(String serviceHostingType) {
        this.serviceHostingType = serviceHostingType;
    }

    @JsonCreator
    public static ServiceHostingType getByValue(String type) {
        for (ServiceHostingType serviceHostingType : ServiceHostingType.values()) {
            if (!serviceHostingType.toValue().equals(StringUtils.lowerCase((String)type))) continue;
            return serviceHostingType;
        }
        throw new UnsupportedEnumValueException(String.format("ServiceHostingType value %s is not supported.", type));
    }

    @JsonValue
    public String toValue() {
        return this.serviceHostingType;
    }
}

