/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpanse.modules.models.system.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xpanse.modules.models.common.exceptions.UnsupportedEnumValueException;

public enum BackendSystemType {
    IDENTITY_PROVIDER("Identity Provider"),
    DATABASE("Database"),
    TERRAFORM_BOOT("Terraform Boot"),
    TOFU_MAKER("Tofu Maker"),
    POLICY_MAN("Policy Man"),
    CACHE_PROVIDER("Cache Provider"),
    OPEN_TELEMETRY_COLLECTOR("OpenTelemetry Collector");

    private final String code;

    private BackendSystemType(String code) {
        this.code = code;
    }

    @JsonCreator
    public static BackendSystemType getByValue(String code) {
        for (BackendSystemType providerType : BackendSystemType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)providerType.code)) continue;
            return providerType;
        }
        throw new UnsupportedEnumValueException(String.format("BackendSystemType value %s is not supported.", code));
    }

    @JsonValue
    public String toValue() {
        return this.code;
    }
}

